/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.synthesizer;

import java.net.URI;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.domain.AssemblyException;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.synthesizer.ComponentRegistrationException;
import org.fabric3.fabric.synthesizer.ComponentSynthesizer;
import org.fabric3.fabric.synthesizer.InvalidServiceContractException;
import org.fabric3.implementation.system.singleton.SingletonComponent;
import org.fabric3.implementation.system.singleton.SingletonImplementation;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.system.SystemImplementation;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

public class SingletonComponentSynthesizer
implements ComponentSynthesizer {
    private ImplementationIntrospector implementationIntrospector;
    private AtomicComponentInstantiator instantiator;
    private LogicalComponentManager lcm;
    private ComponentManager componentManager;
    private JavaContractProcessor contractProcessor;
    private ScopeContainer scopeContainer;

    @Constructor
    public SingletonComponentSynthesizer(@Reference ImplementationIntrospector implementationIntrospector, @Reference AtomicComponentInstantiator instantiator, @Reference LogicalComponentManager lcm, @Reference ComponentManager componentManager, @Reference JavaContractProcessor contractProcessor, @Reference ScopeRegistry registry) {
        this(implementationIntrospector, instantiator, lcm, componentManager, contractProcessor, registry.getScopeContainer(Scope.COMPOSITE));
    }

    public SingletonComponentSynthesizer(ImplementationIntrospector implementationIntrospector, AtomicComponentInstantiator instantiator, LogicalComponentManager lcm, ComponentManager componentManager, JavaContractProcessor contractProcessor, ScopeContainer scopeContainer) {
        this.implementationIntrospector = implementationIntrospector;
        this.instantiator = instantiator;
        this.lcm = lcm;
        this.componentManager = componentManager;
        this.contractProcessor = contractProcessor;
        this.scopeContainer = scopeContainer;
    }

    @Override
    public <S, I extends S> void registerComponent(String name, Class<S> type, I instance, boolean introspect) throws ComponentRegistrationException {
        try {
            LogicalComponent<?> logical = this.createLogicalComponent(name, type, instance, introspect);
            ScopedComponent physical = this.createPhysicalComponent(logical, instance);
            this.componentManager.register((Component)physical);
            this.scopeContainer.register(physical);
            this.scopeContainer.getInstance(physical);
        }
        catch (AssemblyException | ContainerException e) {
            throw new ComponentRegistrationException(e);
        }
    }

    private <S, I extends S> LogicalComponent<?> createLogicalComponent(String name, Class<S> type, I instance, boolean introspect) throws InvalidServiceContractException, AssemblyException {
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        ComponentDefinition<Implementation<?>> definition = this.createDefinition(name, type, instance, introspect);
        InstantiationContext context = new InstantiationContext();
        LogicalComponent<?> logical = this.instantiator.instantiate(definition, domain, context);
        logical.setAutowire(domain.getAutowire());
        if (context.hasErrors()) {
            throw new AssemblyException(context.getErrors());
        }
        logical.setState(LogicalState.PROVISIONED);
        for (LogicalReference reference : logical.getReferences()) {
            reference.setResolved(true);
            for (LogicalWire wire : reference.getWires()) {
                wire.setState(LogicalState.PROVISIONED);
            }
        }
        return logical;
    }

    private <S, I extends S> ComponentDefinition<Implementation<?>> createDefinition(String name, Class<S> type, I instance, boolean introspect) throws InvalidServiceContractException {
        String implClassName = instance.getClass().getName();
        ClassLoader loader = this.getClass().getClassLoader();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(Names.BOOT_CONTRIBUTION, loader);
        if (introspect) {
            SystemImplementation implementation = new SystemImplementation();
            implementation.setImplementationClass(implClassName);
            InjectingComponentType componentType = new InjectingComponentType(implClassName);
            this.implementationIntrospector.introspect(componentType, (IntrospectionContext)context);
            implementation.setComponentType((ComponentType)componentType);
            ComponentDefinition def = new ComponentDefinition(name);
            SingletonImplementation singletonImplementation = new SingletonImplementation((InjectingComponentType)implementation.getComponentType(), implClassName);
            def.setImplementation((Implementation)singletonImplementation);
            def.setContributionUri(Names.BOOT_CONTRIBUTION);
            return def;
        }
        JavaServiceContract contract = this.contractProcessor.introspect(type, (IntrospectionContext)context, new ModelObject[0]);
        if (context.hasErrors()) {
            throw new InvalidServiceContractException(context.getErrors());
        }
        String serviceName = contract.getInterfaceName();
        ServiceDefinition service = new ServiceDefinition(serviceName, (ServiceContract)contract);
        InjectingComponentType componentType = new InjectingComponentType(implClassName);
        componentType.add(service);
        SingletonImplementation implementation = new SingletonImplementation(componentType, implClassName);
        implementation.setComponentType((ComponentType)componentType);
        ComponentDefinition def = new ComponentDefinition(name);
        def.setImplementation((Implementation)implementation);
        def.setContributionUri(Names.BOOT_CONTRIBUTION);
        return def;
    }

    private <I> ScopedComponent createPhysicalComponent(LogicalComponent<?> logicalComponent, I instance) {
        URI uri = logicalComponent.getUri();
        InjectingComponentType type = (InjectingComponentType)logicalComponent.getDefinition().getComponentType();
        type.getInjectionSites();
        SingletonComponent component = new SingletonComponent(uri, instance, type.getInjectionSites());
        component.setClassLoaderId(Names.BOOT_CONTRIBUTION);
        return component;
    }
}

