/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.security;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.fabric3.api.SecuritySubject;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthenticationToken;
import org.fabric3.spi.security.BasicAuthenticator;
import org.fabric3.spi.security.NoCredentialsException;
import org.fabric3.spi.security.UsernamePasswordToken;
import org.fabric3.spi.util.Base64;
import org.oasisopen.sca.annotation.Reference;

public class BasicAuthenticatorImpl
implements BasicAuthenticator {
    private AuthenticationService authenticationService;

    @Reference(required=false)
    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void authenticate(HttpServletRequest request, WorkContext context) throws AuthenticationException, NoCredentialsException {
        if (context.getSubject() != null) {
            return;
        }
        if (this.authenticationService == null) {
            throw new AuthenticationException("Authentication service not installed");
        }
        String header = request.getHeader("Authorization");
        if (header == null || !header.startsWith("Basic ")) {
            throw new NoCredentialsException();
        }
        String base64Token = header.substring(6);
        try {
            String decoded = new String(Base64.decode((String)base64Token), "UTF-8");
            String username = "";
            String password = "";
            int delimeter = decoded.indexOf(":");
            if (delimeter != -1) {
                username = decoded.substring(0, delimeter);
                password = decoded.substring(delimeter + 1);
            }
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            SecuritySubject subject = this.authenticationService.authenticate((AuthenticationToken)token);
            context.setSubject(subject);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

