/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import f3.ContributionServiceProvider;
import f3.FabricProvider;
import f3.JDKReflectionProvider;
import f3.JavaIntrospectionProvider;
import f3.MonitorProvider;
import f3.PojoProvider;
import f3.PolicyProvider;
import f3.SystemImplementationProvider;
import f3.ThreadPoolProvider;
import f3.TransformerProvider;
import f3.XmlIntrospectionProvider;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.InitializationException;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.model.type.builder.CompositeBuilder;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.CompositeImplementation;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.contribution.archive.SyntheticDirectoryClasspathProcessor;
import org.fabric3.contribution.archive.SyntheticDirectoryContributionProcessor;
import org.fabric3.contribution.processor.SymLinkClasspathProcessor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.validation.InvalidCompositeException;
import org.fabric3.spi.model.type.system.SystemComponentDefinitionBuilder;

public class BootstrapCompositeFactory {
    private static final URL COMPOSITE_URL;

    private BootstrapCompositeFactory() {
    }

    public static Composite createSystemComposite(Contribution contribution, HostInfo hostInfo, ClassLoader bootClassLoader, ImplementationIntrospector processor) throws InitializationException {
        CompositeBuilder builder = CompositeBuilder.newBuilder((QName)new QName("urn:fabric3.org", "SystemBootComposite"));
        builder.include(ContributionServiceProvider.getComposite());
        builder.include(FabricProvider.getComposite());
        builder.include(JavaIntrospectionProvider.getComposite());
        builder.include(XmlIntrospectionProvider.getComposite());
        builder.include(JDKReflectionProvider.getComposite());
        builder.include(MonitorProvider.getComposite());
        builder.include(PojoProvider.getComposite());
        builder.include(PolicyProvider.getComposite());
        builder.include(SystemImplementationProvider.getComposite());
        builder.include(ThreadPoolProvider.getComposite());
        builder.include(SystemImplementationProvider.getComposite());
        builder.include(TransformerProvider.getComposite());
        if (!hostInfo.getDeployDirectories().isEmpty()) {
            builder.component(SystemComponentDefinitionBuilder.newBuilder((String)"SyntheticDirectoryContributionProcessor", SyntheticDirectoryContributionProcessor.class).build());
            builder.component(SystemComponentDefinitionBuilder.newBuilder((String)"SyntheticDirectoryClasspathProcessor", SyntheticDirectoryClasspathProcessor.class).build());
            builder.component(SystemComponentDefinitionBuilder.newBuilder((String)"SymLinkClasspathProcessor", SymLinkClasspathProcessor.class).build());
        }
        Composite composite = builder.build();
        URI contributionUri = contribution.getUri();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(contributionUri, bootClassLoader, COMPOSITE_URL);
        for (ComponentDefinition definition : composite.getComponents().values()) {
            processor.introspect((InjectingComponentType)definition.getComponentType(), (IntrospectionContext)context);
        }
        if (context.hasErrors()) {
            QName name = composite.getName();
            List errors = context.getErrors();
            List warnings = context.getWarnings();
            throw new InitializationException((Throwable)new InvalidCompositeException(name, errors, warnings));
        }
        BootstrapCompositeFactory.addContributionUri(contributionUri, composite);
        BootstrapCompositeFactory.addResource(contribution, composite);
        return composite;
    }

    private static void addContributionUri(URI contributionUri, Composite composite) {
        composite.setContributionUri(contributionUri);
        for (ComponentDefinition definition : composite.getComponents().values()) {
            Implementation implementation = definition.getImplementation();
            if (CompositeImplementation.class.isInstance(implementation)) {
                CompositeImplementation compositeImplementation = (CompositeImplementation)CompositeImplementation.class.cast(implementation);
                Composite componentType = (Composite)compositeImplementation.getComponentType();
                BootstrapCompositeFactory.addContributionUri(contributionUri, componentType);
                continue;
            }
            definition.setContributionUri(contributionUri);
        }
    }

    private static void addResource(Contribution contribution, Composite composite) {
        UrlSource source = new UrlSource(COMPOSITE_URL);
        Resource resource = new Resource(contribution, (Source)source, "text/vnd.fabric3.composite+xml");
        QName compositeName = composite.getName();
        QNameSymbol symbol = new QNameSymbol(compositeName);
        ResourceElement element = new ResourceElement((Symbol)symbol, (Object)composite);
        resource.addResourceElement(element);
        resource.setState(ResourceState.PROCESSED);
        contribution.addResource(resource);
    }

    static {
        try {
            COMPOSITE_URL = new URL("file://SystemBootComposite");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

