/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.monitor.MonitorCreationException;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.InitializationException;
import org.fabric3.contribution.generator.JavaContributionWireGenerator;
import org.fabric3.contribution.generator.LocationContributionWireGenerator;
import org.fabric3.contribution.wire.JavaContributionWire;
import org.fabric3.contribution.wire.LocationContributionWire;
import org.fabric3.fabric.container.builder.ConnectorImpl;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.BuildComponentCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.StartComponentCommand;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.fabric.container.executor.AttachWireCommandExecutor;
import org.fabric3.fabric.container.executor.BuildComponentCommandExecutor;
import org.fabric3.fabric.container.executor.CommandExecutorRegistryImpl;
import org.fabric3.fabric.container.executor.ConnectionCommandExecutor;
import org.fabric3.fabric.container.executor.ContextMonitor;
import org.fabric3.fabric.container.executor.StartComponentCommandExecutor;
import org.fabric3.fabric.container.executor.StartContextCommandExecutor;
import org.fabric3.fabric.contract.DefaultContractMatcher;
import org.fabric3.fabric.contract.JavaContractMatcherExtension;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.fabric.domain.ContributionHelperImpl;
import org.fabric3.fabric.domain.LocalDeployer;
import org.fabric3.fabric.domain.RuntimeDomain;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.fabric.domain.collector.CollectorImpl;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.classloader.ClassLoaderCommandGenerator;
import org.fabric3.fabric.domain.generator.classloader.ClassLoaderCommandGeneratorImpl;
import org.fabric3.fabric.domain.generator.collator.ContributionCollatorImpl;
import org.fabric3.fabric.domain.generator.component.BuildComponentCommandGenerator;
import org.fabric3.fabric.domain.generator.component.StartComponentCommandGenerator;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGeneratorImpl;
import org.fabric3.fabric.domain.generator.context.StopContextCommandGeneratorImpl;
import org.fabric3.fabric.domain.generator.impl.GeneratorImpl;
import org.fabric3.fabric.domain.generator.impl.GeneratorRegistryImpl;
import org.fabric3.fabric.domain.generator.policy.NullPolicyAttacher;
import org.fabric3.fabric.domain.generator.policy.NullPolicyResolver;
import org.fabric3.fabric.domain.generator.wire.BoundServiceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.OperationResolverImpl;
import org.fabric3.fabric.domain.generator.wire.PhysicalOperationGeneratorImpl;
import org.fabric3.fabric.domain.generator.wire.ReferenceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.ResourceReferenceCommandGenerator;
import org.fabric3.fabric.domain.generator.wire.WireGeneratorImpl;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiator;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.component.AtomicComponentInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.component.AutowireNormalizerImpl;
import org.fabric3.fabric.domain.instantiator.component.CompositeComponentInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.promotion.PromotionNormalizerImpl;
import org.fabric3.fabric.domain.instantiator.promotion.PromotionResolutionServiceImpl;
import org.fabric3.fabric.domain.instantiator.wire.AutowireInstantiatorImpl;
import org.fabric3.fabric.domain.instantiator.wire.TypeAutowireResolver;
import org.fabric3.fabric.domain.instantiator.wire.WireInstantiatorImpl;
import org.fabric3.fabric.xml.XMLFactoryImpl;
import org.fabric3.implementation.pojo.builder.ArrayBuilder;
import org.fabric3.implementation.pojo.builder.ArrayBuilderImpl;
import org.fabric3.implementation.pojo.builder.CollectionBuilder;
import org.fabric3.implementation.pojo.builder.CollectionBuilderImpl;
import org.fabric3.implementation.pojo.builder.MapBuilder;
import org.fabric3.implementation.pojo.builder.MapBuilderImpl;
import org.fabric3.implementation.pojo.builder.ObjectBuilder;
import org.fabric3.implementation.pojo.builder.ObjectBuilderImpl;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilderImpl;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.generator.GenerationHelperImpl;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilderImpl;
import org.fabric3.implementation.pojo.reflection.ReflectionFactoryImpl;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.InjectorFactory;
import org.fabric3.implementation.pojo.spi.reflection.InstantiatorFactory;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvokerFactory;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvokerFactory;
import org.fabric3.implementation.reflection.jdk.JDKConsumerInvokerFactory;
import org.fabric3.implementation.reflection.jdk.JDKInjectorFactory;
import org.fabric3.implementation.reflection.jdk.JDKInstantiatorFactory;
import org.fabric3.implementation.reflection.jdk.JDKLifecycleInvokerFactory;
import org.fabric3.implementation.reflection.jdk.JDKServiceInvokerFactory;
import org.fabric3.implementation.system.generator.SystemComponentGenerator;
import org.fabric3.implementation.system.provision.SystemComponentDefinition;
import org.fabric3.implementation.system.provision.SystemWireSourceDefinition;
import org.fabric3.implementation.system.provision.SystemWireTargetDefinition;
import org.fabric3.implementation.system.runtime.SystemComponentBuilder;
import org.fabric3.implementation.system.runtime.SystemSourceWireAttacher;
import org.fabric3.implementation.system.runtime.SystemTargetWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonComponentGenerator;
import org.fabric3.implementation.system.singleton.SingletonImplementation;
import org.fabric3.implementation.system.singleton.SingletonSourceWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonTargetWireAttacher;
import org.fabric3.implementation.system.singleton.SingletonWireSourceDefinition;
import org.fabric3.implementation.system.singleton.SingletonWireTargetDefinition;
import org.fabric3.introspection.java.DefaultIntrospectionHelper;
import org.fabric3.monitor.generator.MonitorResourceReferenceGenerator;
import org.fabric3.monitor.model.MonitorResourceReference;
import org.fabric3.monitor.provision.MonitorWireTargetDefinition;
import org.fabric3.monitor.runtime.MonitorWireAttacher;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.builder.Connector;
import org.fabric3.spi.container.builder.component.ComponentBuilder;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contribution.ClassLoaderWireGenerator;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeployerMonitor;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.generator.Generator;
import org.fabric3.spi.domain.generator.policy.PolicyResolver;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.model.type.system.SystemImplementation;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.xml.XMLFactory;
import org.fabric3.transform.DefaultTransformerRegistry;
import org.fabric3.transform.property.Property2BooleanTransformer;
import org.fabric3.transform.property.Property2ElementTransformer;
import org.fabric3.transform.property.Property2IntegerTransformer;
import org.fabric3.transform.property.Property2QNameTransformer;
import org.fabric3.transform.property.Property2StreamTransformer;
import org.fabric3.transform.property.Property2StringTransformer;
import org.fabric3.transform.string2java.String2ClassTransformer;
import org.fabric3.transform.string2java.String2IntegerTransformer;
import org.fabric3.transform.string2java.String2QNameTransformer;

public class BootstrapAssemblyFactory {
    private static final XMLFactory XML_FACTORY = new XMLFactoryImpl();

    private BootstrapAssemblyFactory() {
    }

    public static Domain createDomain(MonitorProxyService monitorService, ClassLoaderRegistry classLoaderRegistry, ScopeRegistry scopeRegistry, ComponentManager componentManager, LogicalComponentManager logicalComponentManager, MetaDataStore metaDataStore, ManagementService managementService, HostInfo info) throws InitializationException {
        DeployerMonitor monitor;
        CommandExecutorRegistry commandRegistry = BootstrapAssemblyFactory.createCommandExecutorRegistry(monitorService, classLoaderRegistry, scopeRegistry, componentManager, managementService, info);
        try {
            monitor = (DeployerMonitor)monitorService.createMonitor(DeployerMonitor.class);
        }
        catch (MonitorCreationException e) {
            throw new InitializationException((Throwable)e);
        }
        LocalDeployer deployer = new LocalDeployer(commandRegistry, scopeRegistry, monitor);
        NullPolicyAttacher policyAttacher = new NullPolicyAttacher();
        NullPolicyResolver policyResolver = new NullPolicyResolver();
        DefaultContractMatcher matcher = new DefaultContractMatcher();
        JavaContractMatcherExtension javaMatcher = new JavaContractMatcherExtension();
        matcher.addMatcherExtension(javaMatcher);
        Generator generator = BootstrapAssemblyFactory.createGenerator(metaDataStore, policyResolver, matcher);
        LogicalModelInstantiator logicalModelInstantiator = BootstrapAssemblyFactory.createLogicalModelGenerator(matcher);
        CollectorImpl collector = new CollectorImpl();
        ContributionHelperImpl contributionHelper = new ContributionHelperImpl(metaDataStore, info);
        return new RuntimeDomain(metaDataStore, generator, logicalModelInstantiator, policyAttacher, logicalComponentManager, (Deployer)deployer, (Collector)collector, (ContributionHelper)contributionHelper, info);
    }

    private static LogicalModelInstantiator createLogicalModelGenerator(ContractMatcher matcher) {
        PromotionResolutionServiceImpl promotionResolutionService = new PromotionResolutionServiceImpl();
        TypeAutowireResolver resolver = new TypeAutowireResolver(matcher);
        AutowireInstantiatorImpl autowireInstantiator = new AutowireInstantiatorImpl(resolver);
        PromotionNormalizerImpl promotionNormalizer = new PromotionNormalizerImpl();
        AutowireNormalizerImpl autowireNormalizer = new AutowireNormalizerImpl();
        AtomicComponentInstantiatorImpl atomicInstantiator = new AtomicComponentInstantiatorImpl();
        WireInstantiatorImpl wireInstantiator = new WireInstantiatorImpl(matcher);
        CompositeComponentInstantiatorImpl compositeInstantiator = new CompositeComponentInstantiatorImpl(atomicInstantiator, wireInstantiator);
        return new LogicalModelInstantiatorImpl(compositeInstantiator, atomicInstantiator, wireInstantiator, autowireInstantiator, promotionNormalizer, autowireNormalizer, promotionResolutionService);
    }

    private static CommandExecutorRegistry createCommandExecutorRegistry(MonitorProxyService monitorService, ClassLoaderRegistry classLoaderRegistry, ScopeRegistry scopeRegistry, ComponentManager componentManager, ManagementService managementService, HostInfo info) {
        DefaultTransformerRegistry transformerRegistry = BootstrapAssemblyFactory.createTransformerRegistry(classLoaderRegistry);
        Connector connector = BootstrapAssemblyFactory.createConnector(componentManager, transformerRegistry, classLoaderRegistry, monitorService);
        CommandExecutorRegistryImpl commandRegistry = new CommandExecutorRegistryImpl();
        try {
            ContextMonitor contextMonitor = (ContextMonitor)monitorService.createMonitor(ContextMonitor.class);
            commandRegistry.register(StartContextCommand.class, new StartContextCommandExecutor(scopeRegistry, contextMonitor));
            BuildComponentCommandExecutor executor = BootstrapAssemblyFactory.createBuildComponentExecutor(componentManager, scopeRegistry, transformerRegistry, classLoaderRegistry, managementService, info);
            commandRegistry.register(BuildComponentCommand.class, executor);
            commandRegistry.register(AttachWireCommand.class, new AttachWireCommandExecutor(connector));
            commandRegistry.register(StartComponentCommand.class, new StartComponentCommandExecutor(componentManager));
            commandRegistry.register(ConnectionCommand.class, new ConnectionCommandExecutor(componentManager, commandRegistry));
        }
        catch (MonitorCreationException e) {
            throw new AssertionError((Object)e);
        }
        return commandRegistry;
    }

    private static BuildComponentCommandExecutor createBuildComponentExecutor(ComponentManager componentManager, ScopeRegistry scopeRegistry, DefaultTransformerRegistry transformerRegistry, ClassLoaderRegistry classLoaderRegistry, ManagementService managementService, HostInfo info) {
        HashMap builders = new HashMap();
        ArrayBuilderImpl arrayBuilder = new ArrayBuilderImpl((TransformerRegistry)transformerRegistry);
        CollectionBuilderImpl collectionBuilder = new CollectionBuilderImpl((TransformerRegistry)transformerRegistry);
        MapBuilderImpl mapBuilder = new MapBuilderImpl((TransformerRegistry)transformerRegistry);
        ObjectBuilderImpl objectBuilder = new ObjectBuilderImpl((TransformerRegistry)transformerRegistry);
        PropertyObjectFactoryBuilderImpl propertyBuilder = new PropertyObjectFactoryBuilderImpl((ArrayBuilder)arrayBuilder, (CollectionBuilder)collectionBuilder, (MapBuilder)mapBuilder, (ObjectBuilder)objectBuilder);
        DefaultIntrospectionHelper helper = new DefaultIntrospectionHelper();
        JDKInstantiatorFactory instantiatorFactory = new JDKInstantiatorFactory();
        JDKInjectorFactory injectorFactory = new JDKInjectorFactory();
        JDKLifecycleInvokerFactory lifecycleInvokerFactory = new JDKLifecycleInvokerFactory();
        JDKServiceInvokerFactory serviceInvokerFactory = new JDKServiceInvokerFactory();
        JDKConsumerInvokerFactory consumerInvokerFactory = new JDKConsumerInvokerFactory();
        ReflectionFactoryImpl reflectionFactory = new ReflectionFactoryImpl((InstantiatorFactory)instantiatorFactory, (InjectorFactory)injectorFactory, (LifecycleInvokerFactory)lifecycleInvokerFactory, (ServiceInvokerFactory)serviceInvokerFactory, (ConsumerInvokerFactory)consumerInvokerFactory);
        ImplementationManagerFactoryBuilderImpl factoryBuilder = new ImplementationManagerFactoryBuilderImpl((ReflectionFactory)reflectionFactory, classLoaderRegistry);
        SystemComponentBuilder builder = new SystemComponentBuilder(scopeRegistry, (ImplementationManagerFactoryBuilder)factoryBuilder, classLoaderRegistry, (PropertyObjectFactoryBuilder)propertyBuilder, managementService, (IntrospectionHelper)helper, info);
        builders.put(SystemComponentDefinition.class, (ComponentBuilder)builder);
        BuildComponentCommandExecutor executor = new BuildComponentCommandExecutor(componentManager);
        executor.setBuilders(builders);
        return executor;
    }

    private static DefaultTransformerRegistry createTransformerRegistry(ClassLoaderRegistry classLoaderRegistry) {
        DefaultTransformerRegistry transformerRegistry = new DefaultTransformerRegistry();
        ArrayList<Object> transformers = new ArrayList<Object>();
        transformers.add(new Property2StringTransformer());
        transformers.add(new Property2IntegerTransformer());
        transformers.add(new Property2BooleanTransformer());
        transformers.add(new Property2ElementTransformer());
        transformers.add(new Property2QNameTransformer());
        transformers.add(new Property2StreamTransformer(XML_FACTORY));
        transformers.add(new String2ClassTransformer(classLoaderRegistry));
        transformers.add(new String2QNameTransformer());
        transformers.add(new String2IntegerTransformer());
        transformerRegistry.setTransformers(transformers);
        return transformerRegistry;
    }

    private static Connector createConnector(ComponentManager componentManager, DefaultTransformerRegistry transformerRegistry, ClassLoaderRegistry classLoaderRegistry, MonitorProxyService monitorService) {
        ConcurrentHashMap<Class<? extends PhysicalWireSourceDefinition>, SourceWireAttacher<? extends PhysicalWireSourceDefinition>> sourceAttachers = new ConcurrentHashMap<Class<? extends PhysicalWireSourceDefinition>, SourceWireAttacher<? extends PhysicalWireSourceDefinition>>();
        SystemSourceWireAttacher wireAttacher = new SystemSourceWireAttacher(componentManager, (TransformerRegistry)transformerRegistry, classLoaderRegistry);
        sourceAttachers.put((Class<? extends PhysicalWireSourceDefinition>)SystemWireSourceDefinition.class, (SourceWireAttacher<? extends PhysicalWireSourceDefinition>)wireAttacher);
        sourceAttachers.put((Class<? extends PhysicalWireSourceDefinition>)SingletonWireSourceDefinition.class, (SourceWireAttacher<? extends PhysicalWireSourceDefinition>)new SingletonSourceWireAttacher(componentManager));
        ConcurrentHashMap<Class<? extends PhysicalWireTargetDefinition>, TargetWireAttacher<? extends PhysicalWireTargetDefinition>> targetAttachers = new ConcurrentHashMap<Class<? extends PhysicalWireTargetDefinition>, TargetWireAttacher<? extends PhysicalWireTargetDefinition>>();
        targetAttachers.put((Class<? extends PhysicalWireTargetDefinition>)SingletonWireTargetDefinition.class, (TargetWireAttacher<? extends PhysicalWireTargetDefinition>)new SingletonTargetWireAttacher(componentManager));
        targetAttachers.put((Class<? extends PhysicalWireTargetDefinition>)SystemWireTargetDefinition.class, (TargetWireAttacher<? extends PhysicalWireTargetDefinition>)new SystemTargetWireAttacher(componentManager, classLoaderRegistry));
        targetAttachers.put((Class<? extends PhysicalWireTargetDefinition>)MonitorWireTargetDefinition.class, (TargetWireAttacher<? extends PhysicalWireTargetDefinition>)new MonitorWireAttacher(monitorService, componentManager, classLoaderRegistry));
        ConnectorImpl connector = new ConnectorImpl();
        connector.setSourceAttachers(sourceAttachers);
        connector.setTargetAttachers(targetAttachers);
        return connector;
    }

    private static Generator createGenerator(MetaDataStore metaDataStore, PolicyResolver resolver, ContractMatcher matcher) {
        GeneratorRegistry generatorRegistry = BootstrapAssemblyFactory.createGeneratorRegistry();
        ClassLoaderCommandGenerator classLoaderGenerator = BootstrapAssemblyFactory.createClassLoaderGenerator();
        List<CommandGenerator> commandGenerators = BootstrapAssemblyFactory.createCommandGenerators(resolver, matcher, generatorRegistry);
        StopContextCommandGeneratorImpl stopContextGenerator = new StopContextCommandGeneratorImpl();
        StartContextCommandGeneratorImpl startContextGenerator = new StartContextCommandGeneratorImpl();
        ContributionCollatorImpl collator = new ContributionCollatorImpl(metaDataStore);
        return new GeneratorImpl(commandGenerators, collator, classLoaderGenerator, startContextGenerator, stopContextGenerator);
    }

    private static GeneratorRegistry createGeneratorRegistry() {
        GeneratorRegistryImpl registry = new GeneratorRegistryImpl();
        GenerationHelperImpl helper = new GenerationHelperImpl();
        SystemComponentGenerator systemComponentGenerator = new SystemComponentGenerator((GenerationHelper)helper);
        SingletonComponentGenerator singletonComponentGenerator = new SingletonComponentGenerator();
        registry.register(SystemImplementation.class, systemComponentGenerator);
        registry.register(SingletonImplementation.class, singletonComponentGenerator);
        registry.register(MonitorResourceReference.class, new MonitorResourceReferenceGenerator());
        return registry;
    }

    private static ClassLoaderCommandGenerator createClassLoaderGenerator() {
        JavaContributionWireGenerator javaGenerator = new JavaContributionWireGenerator();
        LocationContributionWireGenerator locationGenerator = new LocationContributionWireGenerator();
        HashMap generators = new HashMap();
        generators.put((Class<ContributionWire<?, ?>>)JavaContributionWire.class, (ClassLoaderWireGenerator<?>)javaGenerator);
        generators.put((Class<ContributionWire<?, ?>>)LocationContributionWire.class, (ClassLoaderWireGenerator<?>)locationGenerator);
        return new ClassLoaderCommandGeneratorImpl(generators);
    }

    private static List<CommandGenerator> createCommandGenerators(PolicyResolver resolver, ContractMatcher matcher, GeneratorRegistry generatorRegistry) {
        ArrayList<CommandGenerator> commandGenerators = new ArrayList<CommandGenerator>();
        commandGenerators.add(new BuildComponentCommandGenerator(generatorRegistry));
        OperationResolverImpl operationResolver = new OperationResolverImpl();
        PhysicalOperationGeneratorImpl operationGenerator = new PhysicalOperationGeneratorImpl(operationResolver, generatorRegistry);
        WireGeneratorImpl wireGenerator = new WireGeneratorImpl(generatorRegistry, matcher, resolver, operationGenerator);
        commandGenerators.add(new ReferenceCommandGenerator(wireGenerator));
        commandGenerators.add(new BoundServiceCommandGenerator(wireGenerator));
        commandGenerators.add(new ResourceReferenceCommandGenerator(wireGenerator));
        StartComponentCommandGenerator startGenerator = new StartComponentCommandGenerator();
        commandGenerators.add(startGenerator);
        return commandGenerators;
    }
}

