/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.contribution.ContributionException;
import org.fabric3.api.host.contribution.ContributionNotFoundException;
import org.fabric3.api.host.contribution.ContributionOrder;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.InitializationException;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.runtime.RuntimeState;
import org.fabric3.api.host.runtime.ShutdownException;
import org.fabric3.fabric.runtime.DefaultBootstrapper;
import org.fabric3.fabric.runtime.ExtensionInitializationException;
import org.fabric3.spi.runtime.event.DomainRecover;
import org.fabric3.spi.runtime.event.DomainRecovered;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.ExtensionsInitialized;
import org.fabric3.spi.runtime.event.Fabric3Event;
import org.fabric3.spi.runtime.event.JoinDomain;
import org.fabric3.spi.runtime.event.JoinDomainCompleted;
import org.fabric3.spi.runtime.event.RuntimeDestroyed;
import org.fabric3.spi.runtime.event.RuntimeRecover;
import org.fabric3.spi.runtime.event.RuntimeStart;
import org.fabric3.spi.runtime.event.RuntimeStop;

public class DefaultCoordinator
implements RuntimeCoordinator {
    private RuntimeState state = RuntimeState.UNINITIALIZED;
    private BootConfiguration configuration;
    private Fabric3Runtime runtime;

    public DefaultCoordinator(BootConfiguration configuration) {
        this.configuration = configuration;
        this.runtime = configuration.getRuntime();
    }

    public RuntimeState getState() {
        return this.state;
    }

    public void start() throws InitializationException {
        this.boot();
        this.load();
        this.joinDomain();
    }

    public void boot() throws InitializationException {
        this.runtime.boot();
        DefaultBootstrapper bootstrapper = new DefaultBootstrapper(this.configuration);
        bootstrapper.bootRuntimeDomain();
        bootstrapper.bootSystem();
    }

    public void load() throws InitializationException {
        this.loadExtensions();
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new ExtensionsInitialized());
        this.recover(eventService);
    }

    public void joinDomain() {
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new JoinDomain());
        eventService.publish((Fabric3Event)new JoinDomainCompleted());
        eventService.publish((Fabric3Event)new DomainRecover());
        eventService.publish((Fabric3Event)new DomainRecovered());
        eventService.publish((Fabric3Event)new RuntimeStart());
        this.state = RuntimeState.STARTED;
    }

    public void shutdown() throws ShutdownException {
        if (this.state == RuntimeState.STARTED) {
            EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
            eventService.publish((Fabric3Event)new RuntimeStop());
            RuntimeDestroyed destroyed = new RuntimeDestroyed();
            this.runtime.destroy();
            eventService.publish((Fabric3Event)destroyed);
        }
        this.state = RuntimeState.SHUTDOWN;
    }

    private void loadExtensions() throws InitializationException {
        List contributions = this.configuration.getExtensionContributions();
        ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class);
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.RUNTIME_DOMAIN_SERVICE_URI);
        try {
            ContributionOrder order = contributionService.processManifests(contributions);
            for (URI uri : order.getBaseContributions()) {
                contributionService.processContents(uri);
            }
            domain.include(order.getBaseContributions());
            for (URI uri : order.getIsolatedContributions()) {
                contributionService.processContents(uri);
                domain.include(Collections.singletonList(uri));
            }
        }
        catch (ContributionNotFoundException | InstallException | StoreException e) {
            throw new InitializationException(e);
        }
        catch (DeploymentException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error deploying extensions", e);
        }
    }

    private void recover(EventService eventService) throws InitializationException {
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.APPLICATION_DOMAIN_URI);
        if (domain == null) {
            this.state = RuntimeState.ERROR;
            String name = Names.APPLICATION_DOMAIN_URI.toString();
            throw new InitializationException("Domain not found: " + name);
        }
        List contributions = this.configuration.getUserContributions();
        if (!contributions.isEmpty()) {
            this.installContributions(contributions);
        }
        eventService.publish((Fabric3Event)new RuntimeRecover());
    }

    private List<URI> installContributions(List<ContributionSource> sources) throws InitializationException {
        try {
            ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class, Names.CONTRIBUTION_SERVICE_URI);
            List stored = contributionService.store(sources);
            return contributionService.install(stored);
        }
        catch (ContributionException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error contributing extensions", e);
        }
    }
}

