/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.BootstrapService;
import org.fabric3.api.host.runtime.ComponentRegistration;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.ParseException;
import org.fabric3.api.host.runtime.RuntimeConfiguration;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.runtime.ScanException;
import org.fabric3.api.host.runtime.ScanResult;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.node.Fabric;
import org.fabric3.fabric.runtime.DefaultCoordinator;
import org.fabric3.fabric.runtime.DefaultRuntime;
import org.fabric3.fabric.runtime.RuntimeFabric;
import org.fabric3.fabric.runtime.bootstrap.RepositoryScanner;
import org.fabric3.fabric.runtime.bootstrap.SystemConfigLoader;
import org.w3c.dom.Document;

public class DefaultBootstrapService
implements BootstrapService {
    private RepositoryScanner scanner = new RepositoryScanner();
    private SystemConfigLoader systemConfigLoader = new SystemConfigLoader();

    public Document loadSystemConfig(File configDirectory) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(configDirectory);
    }

    public Document loadSystemConfig(Source source) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(source);
    }

    public Document createDefaultSystemConfig() {
        return this.systemConfigLoader.createDefaultSystemConfig();
    }

    public URI parseDomainName(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseDomainName(systemConfig);
    }

    public String parseZoneName(Document systemConfig, RuntimeMode mode) throws ParseException {
        return this.systemConfigLoader.parseZoneName(systemConfig, mode);
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseRuntimeMode(systemConfig);
    }

    public String parseEnvironment(Document systemConfig) {
        return this.systemConfigLoader.parseEnvironment(systemConfig);
    }

    public List<File> parseDeployDirectories(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseDeployDirectories(systemConfig);
    }

    public String parseProductName(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseProductName(systemConfig);
    }

    public String getRuntimeName(URI domainName, String zoneName, String runtimeId, RuntimeMode mode) {
        String runtimeName = RuntimeMode.CONTROLLER == mode ? domainName.getAuthority() + ":controller:" + runtimeId : (RuntimeMode.PARTICIPANT == mode ? domainName.getAuthority() + ":participant:" + zoneName + ":" + runtimeId : (RuntimeMode.NODE == mode ? domainName.getAuthority() + ":node:" + zoneName + ":" + runtimeId : "vm"));
        return runtimeName;
    }

    public ScanResult scanRepository(HostInfo info) throws ScanException {
        return this.scanner.scan(info);
    }

    public Fabric3Runtime createDefaultRuntime(RuntimeConfiguration configuration) {
        return new DefaultRuntime(configuration);
    }

    public List<ComponentRegistration> createDefaultRegistrations(Fabric3Runtime runtime) {
        ArrayList<ComponentRegistration> registrations = new ArrayList<ComponentRegistration>();
        RuntimeFabric fabric = new RuntimeFabric(runtime);
        ComponentRegistration registration = new ComponentRegistration("Fabric", Fabric.class, (Object)fabric, false);
        registrations.add(registration);
        return registrations;
    }

    public RuntimeCoordinator createCoordinator(BootConfiguration configuration) {
        return new DefaultCoordinator(configuration);
    }
}

