/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.management.MBeanServer;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MonitorCreationException;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.api.host.repository.Repository;
import org.fabric3.api.host.repository.RepositoryException;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.InitializationException;
import org.fabric3.api.host.runtime.RuntimeConfiguration;
import org.fabric3.api.host.runtime.ShutdownException;
import org.fabric3.contribution.MetaDataStoreImpl;
import org.fabric3.contribution.ProcessorRegistryImpl;
import org.fabric3.fabric.classloader.ClassLoaderRegistryImpl;
import org.fabric3.fabric.container.channel.ChannelManagerImpl;
import org.fabric3.fabric.container.component.ComponentManagerImpl;
import org.fabric3.fabric.container.component.scope.CompositeScopeContainer;
import org.fabric3.fabric.container.component.scope.ScopeContainerMonitor;
import org.fabric3.fabric.container.component.scope.ScopeRegistryImpl;
import org.fabric3.fabric.domain.LogicalComponentManagerImpl;
import org.fabric3.fabric.management.DelegatingManagementService;
import org.fabric3.fabric.repository.RepositoryImpl;
import org.fabric3.fabric.runtime.RuntimeServices;
import org.fabric3.monitor.proxy.JDKMonitorProxyService;
import org.fabric3.monitor.proxy.MonitorProxyServiceImpl;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.management.ManagementService;

public abstract class AbstractRuntime
implements Fabric3Runtime,
RuntimeServices {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private HostInfo hostInfo;
    private MonitorProxyService monitorService;
    private LogicalComponentManager logicalComponentManager;
    private ComponentManager componentManager;
    private ChannelManager channelManager;
    private CompositeScopeContainer scopeContainer;
    private ClassLoaderRegistry classLoaderRegistry;
    private MetaDataStore metaDataStore;
    private ScopeRegistry scopeRegistry;
    private ManagementService managementService;
    private MBeanServer mbServer;
    private Repository repository;
    private DestinationRouter router;
    private MonitorLevel level = MonitorLevel.INFO;

    protected AbstractRuntime(RuntimeConfiguration configuration) {
        this.hostInfo = configuration.getHostInfo();
        this.mbServer = configuration.getMBeanServer();
        this.router = configuration.getDestinationRouter();
        this.repository = configuration.getRepository();
        System.setProperty(JAVA_LIBRARY_PATH, new File(this.hostInfo.getTempDir(), "native").getAbsolutePath());
    }

    @Override
    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    @Override
    public MonitorProxyService getMonitorProxyService() {
        return this.monitorService;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbServer;
    }

    public String getName() {
        return "fabric3://runtime";
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void boot() throws InitializationException {
        ScopeContainerMonitor monitor;
        this.logicalComponentManager = new LogicalComponentManagerImpl();
        this.componentManager = new ComponentManagerImpl();
        this.channelManager = new ChannelManagerImpl();
        this.classLoaderRegistry = new ClassLoaderRegistryImpl();
        ProcessorRegistryImpl processorRegistry = new ProcessorRegistryImpl();
        this.metaDataStore = new MetaDataStoreImpl((ProcessorRegistry)processorRegistry);
        this.monitorService = new MonitorProxyServiceImpl(new JDKMonitorProxyService((Monitorable)this, this.router));
        try {
            monitor = (ScopeContainerMonitor)this.monitorService.createMonitor(ScopeContainerMonitor.class);
        }
        catch (MonitorCreationException e) {
            throw new InitializationException((Throwable)e);
        }
        this.scopeContainer = new CompositeScopeContainer(monitor);
        this.scopeContainer.start();
        this.scopeRegistry = new ScopeRegistryImpl();
        this.scopeRegistry.register((ScopeContainer)this.scopeContainer);
        this.managementService = new DelegatingManagementService();
        if (this.repository == null) {
            this.repository = this.createRepository();
        }
    }

    public void destroy() throws ShutdownException {
        WorkContextCache.getAndResetThreadWorkContext();
        this.scopeContainer.stopAllContexts();
        try {
            this.repository.shutdown();
            this.classLoaderRegistry.close();
        }
        catch (IOException | RepositoryException e) {
            throw new ShutdownException(e);
        }
    }

    public <I> I getComponent(Class<I> service, URI uri) {
        if (RuntimeServices.class.equals(service)) {
            return service.cast(this);
        }
        ScopedComponent component = (ScopedComponent)this.componentManager.getComponent(uri);
        if (component == null) {
            return null;
        }
        try {
            Object instance = component.getInstance();
            return service.cast(instance);
        }
        catch (InstanceLifecycleException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <I> I getComponent(Class<I> service) {
        return this.getComponent(service, URI.create("fabric3://runtime/" + service.getSimpleName()));
    }

    @Override
    public LogicalComponentManager getLogicalComponentManager() {
        return this.logicalComponentManager;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    @Override
    public ScopeContainer getScopeContainer() {
        return this.scopeContainer;
    }

    @Override
    public ClassLoaderRegistry getClassLoaderRegistry() {
        return this.classLoaderRegistry;
    }

    @Override
    public MetaDataStore getMetaDataStore() {
        return this.metaDataStore;
    }

    @Override
    public ScopeRegistry getScopeRegistry() {
        return this.scopeRegistry;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public DestinationRouter getDestinationRouter() {
        return this.router;
    }

    protected Repository createRepository() throws InitializationException {
        try {
            RepositoryImpl repository = new RepositoryImpl(this.hostInfo);
            repository.init();
            return repository;
        }
        catch (RepositoryException e) {
            throw new InitializationException((Throwable)e);
        }
    }
}

