/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.host.repository.Repository;
import org.fabric3.api.host.repository.RepositoryException;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.util.FileHelper;

public class RepositoryImpl
implements Repository {
    private Map<URI, URL> archiveUriToUrl = new ConcurrentHashMap<URI, URL>();
    private File runtimeDirectory;
    private File userDirectory;
    private File sharedDirectory;

    public RepositoryImpl(HostInfo info) {
        this.runtimeDirectory = info.getRuntimeRepositoryDirectory();
        this.sharedDirectory = info.getExtensionsRepositoryDirectory();
        this.userDirectory = info.getUserRepositoryDirectory();
    }

    public void init() throws RepositoryException {
        if (this.runtimeDirectory == null || !this.runtimeDirectory.exists() || !this.runtimeDirectory.isDirectory()) {
            return;
        }
        try {
            for (File file : this.sharedDirectory.listFiles()) {
                this.archiveUriToUrl.put(this.mapToUri(file), file.toURI().toURL());
            }
            for (File file : this.runtimeDirectory.listFiles()) {
                this.archiveUriToUrl.put(this.mapToUri(file), file.toURI().toURL());
            }
            for (File file : this.userDirectory.listFiles()) {
                this.archiveUriToUrl.put(this.mapToUri(file), file.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void shutdown() throws RepositoryException {
    }

    public URL store(URI uri, InputStream stream, boolean extension) throws RepositoryException {
        try {
            File location = extension ? this.mapToFile(this.runtimeDirectory, uri) : this.mapToFile(this.userDirectory, uri);
            FileHelper.write((InputStream)stream, (File)location);
            URL locationUrl = location.toURI().toURL();
            this.archiveUriToUrl.put(uri, locationUrl);
            return locationUrl;
        }
        catch (IOException e) {
            String id = uri.toString();
            throw new RepositoryException("Error storing: " + id, (Throwable)e);
        }
    }

    public boolean exists(URI uri) {
        return this.archiveUriToUrl.containsKey(uri);
    }

    public URL find(URI uri) {
        return this.archiveUriToUrl.get(uri);
    }

    public void remove(URI uri) throws RepositoryException {
        try {
            File location = this.mapToFile(this.userDirectory, uri);
            if (!location.exists()) {
                location = this.mapToFile(this.runtimeDirectory, uri);
            }
            this.archiveUriToUrl.remove(uri);
            location.delete();
        }
        catch (IOException e) {
            String id = uri.toString();
            throw new RepositoryException("Error removing: " + id, (Throwable)e);
        }
    }

    public List<URI> list() {
        return new ArrayList<URI>(this.archiveUriToUrl.keySet());
    }

    private File mapToFile(File base, URI uri) throws IOException {
        if (!(base.exists() && base.isDirectory() && base.canRead())) {
            throw new IOException("The repository location is not a directory: " + base);
        }
        return new File(base, uri.getPath());
    }

    private URI mapToUri(File file) {
        return URI.create(file.getName());
    }
}

