/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.management;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.management.ManagementException;
import org.fabric3.spi.management.ManagementExtension;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.Reference;

public class DelegatingManagementService
implements ManagementService {
    private Map<String, ManagementExtension> extensions = new HashMap<String, ManagementExtension>();
    private List<ComponentHolder> componentHolders = new ArrayList<ComponentHolder>();
    private List<InstanceHolder> instanceHolders = new ArrayList<InstanceHolder>();

    @Reference(required=false)
    public void setExtensions(List<ManagementExtension> injected) throws ManagementException {
        this.extensions.clear();
        for (ManagementExtension extension : injected) {
            this.extensions.put(extension.getType(), extension);
        }
        this.exportComponents();
        this.exportInstances();
    }

    public void export(URI componentUri, ManagementInfo info, ObjectFactory<?> objectFactory, ClassLoader classLoader) throws ManagementException {
        ComponentHolder holder = new ComponentHolder(componentUri, info, objectFactory, classLoader);
        for (Map.Entry<String, ManagementExtension> entry : this.extensions.entrySet()) {
            String type = entry.getKey();
            ManagementExtension extension = entry.getValue();
            extension.export(componentUri, info, objectFactory, classLoader);
            holder.registered.add(type);
        }
        this.componentHolders.add(holder);
    }

    public void export(String name, String group, String description, Object instance) throws ManagementException {
        InstanceHolder holder = new InstanceHolder(name, group, description, instance);
        for (Map.Entry<String, ManagementExtension> entry : this.extensions.entrySet()) {
            String type = entry.getKey();
            ManagementExtension extension = entry.getValue();
            extension.export(name, group, description, instance);
            holder.registered.add(type);
        }
        this.instanceHolders.add(holder);
    }

    public void remove(URI componentUri, ManagementInfo info) throws ManagementException {
        Iterator<ComponentHolder> iterator = this.componentHolders.iterator();
        while (iterator.hasNext()) {
            ComponentHolder holder = iterator.next();
            if (!holder.componentUri.equals(componentUri)) continue;
            for (String type : holder.registered) {
                ManagementExtension extension = this.extensions.get(type);
                if (extension == null) continue;
                extension.remove(componentUri, info);
            }
            iterator.remove();
            return;
        }
    }

    public void remove(String name, String group) throws ManagementException {
        Iterator<InstanceHolder> iterator = this.instanceHolders.iterator();
        while (iterator.hasNext()) {
            InstanceHolder holder = iterator.next();
            if (!holder.name.equals(name) || !holder.group.equals(group)) continue;
            for (String type : holder.registered) {
                ManagementExtension extension = this.extensions.get(type);
                if (extension == null) continue;
                extension.remove(name, group);
            }
            iterator.remove();
            return;
        }
    }

    private void exportComponents() throws ManagementException {
        for (Map.Entry<String, ManagementExtension> entry : this.extensions.entrySet()) {
            String type = entry.getKey();
            ManagementExtension extension = entry.getValue();
            for (ComponentHolder holder : this.componentHolders) {
                if (holder.registered.contains(type)) continue;
                extension.export(holder.componentUri, holder.info, holder.objectFactory, holder.classLoader);
                holder.registered.add(type);
            }
        }
    }

    private void exportInstances() throws ManagementException {
        for (Map.Entry<String, ManagementExtension> entry : this.extensions.entrySet()) {
            String type = entry.getKey();
            ManagementExtension extension = entry.getValue();
            for (InstanceHolder holder : this.instanceHolders) {
                if (holder.registered.contains(type)) continue;
                extension.export(holder.name, holder.group, holder.description, holder.instance);
                holder.registered.add(type);
            }
        }
    }

    private class InstanceHolder {
        private String name;
        private String group;
        private String description;
        private Object instance;
        private List<String> registered = new ArrayList<String>();

        private InstanceHolder(String name, String group, String description, Object instance) {
            this.name = name;
            this.group = group;
            this.description = description;
            this.instance = instance;
        }
    }

    private class ComponentHolder {
        private URI componentUri;
        private ManagementInfo info;
        private ObjectFactory objectFactory;
        private ClassLoader classLoader;
        private List<String> registered = new ArrayList<String>();

        public ComponentHolder(URI componentUri, ManagementInfo info, ObjectFactory<?> objectFactory, ClassLoader classLoader) {
            this.componentUri = componentUri;
            this.info = info;
            this.objectFactory = objectFactory;
            this.classLoader = classLoader;
        }
    }
}

