/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.host;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.fabric.host.PortAllocatedException;
import org.fabric3.fabric.host.PortImpl;
import org.fabric3.fabric.host.PortNameAllocatedException;
import org.fabric3.spi.host.Port;
import org.fabric3.spi.host.PortAllocationException;
import org.fabric3.spi.host.PortAllocator;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;

@Management(name="PortAllocator", path="/runtime/ports", group="kernel", description="Manages runtime ports")
public class PortAllocatorImpl
implements PortAllocator {
    private int min = -1;
    private int max = -1;
    private String configuredHost;
    private Map<String, List<Port>> allocated = new HashMap<String, List<Port>>();
    private LinkedList<Integer> unallocated = new LinkedList();

    @Property(required=false)
    @Source(value="$systemConfig/f3:runtime/@port.range")
    public void setRange(String range) {
        String[] tokens = range.split("-");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid port range specified in the runtime system configuration");
        }
        this.min = this.parsePortNumber(tokens[0]);
        this.max = this.parsePortNumber(tokens[1]);
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:runtime/@host.address")
    public void setHost(String host) {
        this.configuredHost = host;
    }

    @Init
    public void init() throws PortAllocationException {
        if (this.min == -1 && this.max == -1) {
            return;
        }
        if (this.min > 0) {
            if (this.max < 0) {
                throw new IllegalArgumentException("Invalid maximum port value: " + this.max);
            }
        } else if (this.max > 0) {
            throw new IllegalArgumentException("Invalid minimum port value: " + this.min);
        }
        if (this.max < this.min) {
            throw new IllegalArgumentException("Maximum port cannot be less than minimum port");
        }
        for (int i = this.min; i <= this.max; ++i) {
            this.unallocated.add(i);
        }
    }

    @Destroy
    public void destroy() {
        for (List<Port> ports : this.allocated.values()) {
            for (Port port : ports) {
                port.release();
            }
        }
    }

    @ManagementOperation(path="/")
    public Map<String, List<Port>> getAllocatedPorts() {
        return this.allocated;
    }

    @ManagementOperation
    public List<Port> getAllocatedPorts(String type) {
        List<Port> ports = this.allocated.get(type);
        if (ports == null) {
            return Collections.emptyList();
        }
        return ports;
    }

    public boolean isPoolEnabled() {
        return this.min != -1 && this.max != -1;
    }

    public Port allocate(String name, String type) throws PortAllocationException {
        int portNumber;
        SocketPair pair;
        List<Port> ports = this.checkAllocated(name, type);
        do {
            if (!this.unallocated.isEmpty()) continue;
            throw new PortAllocationException("No ports available");
        } while ((pair = this.checkAvailability(portNumber = this.unallocated.remove().intValue())) == null);
        PortImpl port = new PortImpl(name, portNumber, pair.getServerSocket(), pair.getDatagramSocket());
        if (ports == null) {
            ports = new ArrayList<Port>();
            this.allocated.put(type, ports);
        }
        ports.add(port);
        return port;
    }

    public Port reserve(String name, String type, int portNumber) throws PortAllocationException {
        List<Port> ports = this.checkAllocated(name, type);
        SocketPair pair = this.checkAvailability(portNumber);
        if (pair == null) {
            throw new PortAllocatedException(portNumber);
        }
        int pos = this.unallocated.indexOf(portNumber);
        if (pos >= 0) {
            this.unallocated.remove(pos);
        }
        PortImpl port = new PortImpl(name, portNumber, pair.getServerSocket(), pair.getDatagramSocket());
        if (ports == null) {
            ports = new ArrayList<Port>();
            this.allocated.put(type, ports);
        }
        ports.add(port);
        return port;
    }

    public int getAllocatedPortNumber(String name) {
        for (List<Port> ports : this.allocated.values()) {
            for (Port port : ports) {
                if (!port.getName().equals(name)) continue;
                return port.getNumber();
            }
        }
        return -1;
    }

    public Set<String> getPortTypes() {
        return this.allocated.keySet();
    }

    public void release(int portNumber) {
        Iterator<Map.Entry<String, List<Port>>> iterator = this.allocated.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Port>> entry = iterator.next();
            List<Port> ports = entry.getValue();
            Iterator<Port> portIterator = ports.iterator();
            while (portIterator.hasNext()) {
                Port port = portIterator.next();
                if (port.getNumber() != portNumber) continue;
                portIterator.remove();
                this.unallocated.add(portNumber);
                if (ports.isEmpty()) {
                    iterator.remove();
                }
                port.release();
                return;
            }
        }
    }

    public void release(String name) {
        Iterator<Map.Entry<String, List<Port>>> iterator = this.allocated.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Port>> entry = iterator.next();
            List<Port> ports = entry.getValue();
            Iterator<Port> portIterator = ports.iterator();
            while (portIterator.hasNext()) {
                Port port = portIterator.next();
                if (!port.getName().equals(name)) continue;
                portIterator.remove();
                this.unallocated.add(port.getNumber());
                if (ports.isEmpty()) {
                    iterator.remove();
                }
                port.release();
                return;
            }
        }
    }

    public void releaseAll(String type) {
        List<Port> ports = this.allocated.remove(type);
        if (ports != null) {
            for (Port port : ports) {
                this.unallocated.add(port.getNumber());
                port.release();
            }
        }
    }

    private List<Port> checkAllocated(String name, String type) throws PortNameAllocatedException {
        List<Port> ports = this.allocated.get(type);
        if (ports != null) {
            for (Port port : ports) {
                if (!port.getName().equals(name)) continue;
                throw new PortNameAllocatedException(type);
            }
        }
        return ports;
    }

    private SocketPair checkAvailability(int port) throws PortAllocationException {
        SocketPair pair = this.lockPort(port);
        if (pair == null) {
            return null;
        }
        return pair;
    }

    private SocketPair lockPort(int port) {
        try {
            ServerSocket serverSocket = new ServerSocket();
            InetAddress address = null;
            if (this.configuredHost != null) {
                address = InetAddress.getByName(this.configuredHost);
            }
            InetSocketAddress socketAddress = new InetSocketAddress(address, port);
            serverSocket.setReuseAddress(true);
            serverSocket.bind(socketAddress);
            DatagramSocket datagramSocket = new DatagramSocket(port, address);
            datagramSocket.setReuseAddress(true);
            return new SocketPair(serverSocket, datagramSocket);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private int parsePortNumber(String portVal) {
        try {
            int port = Integer.parseInt(portVal);
            if (port < 0) {
                throw new IllegalArgumentException("Invalid port range specified in the runtime system configuration: " + port);
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port range specified in the runtime system configuration: ", e);
        }
    }

    private class SocketPair {
        private ServerSocket serverSocket;
        private DatagramSocket datagramSocket;

        private SocketPair(ServerSocket serverSocket, DatagramSocket datagramSocket) {
            this.serverSocket = serverSocket;
            this.datagramSocket = datagramSocket;
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        public DatagramSocket getDatagramSocket() {
            return this.datagramSocket;
        }
    }
}

