/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.federation.addressing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.spi.federation.addressing.AddressAnnouncement;
import org.fabric3.spi.federation.addressing.AddressCache;
import org.fabric3.spi.federation.addressing.AddressEvent;
import org.fabric3.spi.federation.addressing.AddressListener;
import org.fabric3.spi.federation.addressing.AddressMonitor;
import org.fabric3.spi.federation.addressing.AddressRequest;
import org.fabric3.spi.federation.addressing.AddressUpdate;
import org.fabric3.spi.federation.addressing.SocketAddress;
import org.fabric3.spi.federation.topology.ControllerTopologyService;
import org.fabric3.spi.federation.topology.MessageException;
import org.fabric3.spi.federation.topology.MessageReceiver;
import org.fabric3.spi.federation.topology.ParticipantTopologyService;
import org.fabric3.spi.federation.topology.TopologyListener;
import org.fabric3.spi.federation.topology.ZoneChannelException;
import org.fabric3.spi.runtime.event.EventService;
import org.fabric3.spi.runtime.event.Fabric3EventListener;
import org.fabric3.spi.runtime.event.JoinDomainCompleted;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(value={AddressCache.class})
public class AddressCacheImpl
implements AddressCache,
TopologyListener,
MessageReceiver,
Fabric3EventListener<JoinDomainCompleted> {
    private static final String ADDRESS_CHANNEL = "F3AddressChannel";
    private ParticipantTopologyService participantTopologyService;
    private ControllerTopologyService controllerTopologyService;
    private Executor executor;
    private EventService eventService;
    private HostInfo info;
    private AddressMonitor monitor;
    private String qualifiedChannelName;
    protected Map<String, List<SocketAddress>> addresses = new ConcurrentHashMap<String, List<SocketAddress>>();
    protected Map<String, List<AddressListener>> listeners = new ConcurrentHashMap<String, List<AddressListener>>();

    public AddressCacheImpl(@Reference Executor executor, @Reference EventService eventService, @Reference HostInfo info, @Monitor AddressMonitor monitor) {
        this.executor = executor;
        this.eventService = eventService;
        this.info = info;
        this.monitor = monitor;
        this.qualifiedChannelName = "F3AddressChannel." + info.getDomain().getAuthority();
    }

    @Reference(required=false)
    public void setParticipantTopologyService(ParticipantTopologyService participantTopologyService) {
        this.participantTopologyService = participantTopologyService;
    }

    @Reference(required=false)
    public void setControllerTopologyService(ControllerTopologyService controllerTopologyService) {
        this.controllerTopologyService = controllerTopologyService;
    }

    @Init
    public void init() {
        this.eventService.subscribe(JoinDomainCompleted.class, (Fabric3EventListener)this);
        if (this.isParticipantOrNode()) {
            this.participantTopologyService.register((TopologyListener)this);
        }
    }

    @Destroy
    public void destroy() throws ZoneChannelException {
        if (this.isParticipantOrNode()) {
            this.participantTopologyService.closeChannel(this.qualifiedChannelName);
            this.participantTopologyService.deregister((TopologyListener)this);
        } else if (this.isController()) {
            this.controllerTopologyService.closeChannel(this.qualifiedChannelName);
        }
    }

    public List<SocketAddress> getActiveAddresses(String endpointId) {
        List<SocketAddress> list = this.addresses.get(endpointId);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void publish(AddressEvent event) {
        this.publish(event, true);
    }

    public void subscribe(String endpointId, AddressListener listener) {
        List<AddressListener> list = this.listeners.get(endpointId);
        if (list == null) {
            list = new CopyOnWriteArrayList<AddressListener>();
            this.listeners.put(endpointId, list);
        }
        list.add(listener);
    }

    public void unsubscribe(String endpointId, String listenerId) {
        List<AddressListener> list = this.listeners.get(endpointId);
        if (list == null) {
            return;
        }
        ArrayList<AddressListener> deleted = new ArrayList<AddressListener>();
        for (AddressListener listener : list) {
            if (!listenerId.equals(listener.getId())) continue;
            deleted.add(listener);
            if (!list.isEmpty()) break;
            this.listeners.remove(endpointId);
            break;
        }
        for (AddressListener listener : deleted) {
            list.remove(listener);
        }
    }

    protected void notifyChange(String endpointId) {
        List<AddressListener> list;
        List<Object> addresses = this.addresses.get(endpointId);
        if (addresses == null) {
            addresses = Collections.emptyList();
        }
        if ((list = this.listeners.get(endpointId)) == null) {
            return;
        }
        for (AddressListener listener : list) {
            listener.onUpdate(addresses);
        }
    }

    public void onMessage(Object object) {
        if (object instanceof AddressAnnouncement) {
            AddressAnnouncement announcement = (AddressAnnouncement)object;
            this.publish((AddressEvent)announcement, false);
        } else if (object instanceof AddressUpdate) {
            AddressUpdate update = (AddressUpdate)object;
            for (AddressAnnouncement announcement : update.getAnnouncements()) {
                this.publish((AddressEvent)announcement, false);
            }
        } else if (object instanceof AddressRequest) {
            this.handleAddressRequest((AddressRequest)object);
        }
    }

    public void onLeave(String name) {
        for (Map.Entry<String, List<SocketAddress>> entry : this.addresses.entrySet()) {
            ArrayList<SocketAddress> toDelete = new ArrayList<SocketAddress>();
            List<SocketAddress> list = entry.getValue();
            for (SocketAddress address : list) {
                if (!name.equals(address.getRuntimeName())) continue;
                toDelete.add(address);
            }
            for (SocketAddress address : toDelete) {
                this.monitor.removed(name, address.toString());
                list.remove(address);
            }
            if (list.isEmpty()) {
                this.addresses.remove(entry.getKey());
            }
            this.notifyChange(entry.getKey());
        }
    }

    public void onJoin(String name) {
    }

    public void onLeaderElected(String name) {
    }

    public void onEvent(JoinDomainCompleted event) {
        try {
            if (this.isParticipantOrNode()) {
                this.participantTopologyService.openChannel(this.qualifiedChannelName, null, (MessageReceiver)this, null);
                AddressRequest request = new AddressRequest(this.info.getRuntimeName());
                this.participantTopologyService.sendAsynchronous(this.qualifiedChannelName, (Serializable)request);
            } else if (this.isController()) {
                this.controllerTopologyService.openChannel(this.qualifiedChannelName, null, (MessageReceiver)this, (TopologyListener)this);
                AddressRequest request = new AddressRequest(this.info.getRuntimeName());
                this.controllerTopologyService.sendAsynchronous(this.qualifiedChannelName, (Serializable)request);
            }
        }
        catch (MessageException e) {
            this.monitor.error((Exception)((Object)e));
        }
    }

    private void publish(AddressEvent event, boolean propagate) {
        if (event instanceof AddressAnnouncement) {
            AddressAnnouncement announcement = (AddressAnnouncement)event;
            String endpointId = announcement.getEndpointId();
            List<SocketAddress> addresses = this.addresses.get(endpointId);
            SocketAddress address = announcement.getAddress();
            if (AddressAnnouncement.Type.ACTIVATED == announcement.getType()) {
                if (addresses == null) {
                    addresses = new CopyOnWriteArrayList<SocketAddress>();
                    this.addresses.put(endpointId, addresses);
                }
                this.monitor.added(endpointId, address.toString());
                addresses.add(address);
            } else if (addresses != null) {
                this.monitor.removed(endpointId, address.toString());
                addresses.remove(address);
                if (addresses.isEmpty()) {
                    this.addresses.remove(endpointId);
                }
            }
            if (propagate && this.isParticipantOrNode() && event instanceof AddressAnnouncement) {
                try {
                    this.participantTopologyService.sendAsynchronous(this.qualifiedChannelName, (Serializable)event);
                }
                catch (MessageException e) {
                    this.monitor.error((Exception)((Object)e));
                }
            }
            this.notifyChange(endpointId);
        }
    }

    private void handleAddressRequest(final AddressRequest request) {
        this.monitor.receivedRequest(request.getRuntimeName());
        final AddressUpdate update = new AddressUpdate();
        for (Map.Entry<String, List<SocketAddress>> entry : this.addresses.entrySet()) {
            for (SocketAddress address : entry.getValue()) {
                if (!this.info.getRuntimeName().equals(address.getRuntimeName())) continue;
                AddressAnnouncement announcement = new AddressAnnouncement(entry.getKey(), AddressAnnouncement.Type.ACTIVATED, address);
                update.addAnnouncement(announcement);
            }
        }
        if (!update.getAnnouncements().isEmpty()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AddressCacheImpl.this.isParticipantOrNode()) {
                            AddressCacheImpl.this.participantTopologyService.sendAsynchronous(request.getRuntimeName(), AddressCacheImpl.this.qualifiedChannelName, (Serializable)update);
                        }
                    }
                    catch (MessageException e) {
                        AddressCacheImpl.this.monitor.error((Exception)((Object)e));
                    }
                }
            });
        }
    }

    private boolean isParticipantOrNode() {
        return RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() || RuntimeMode.NODE == this.info.getRuntimeMode();
    }

    private boolean isController() {
        return RuntimeMode.CONTROLLER == this.info.getRuntimeMode();
    }
}

