/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.wire;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.domain.instantiator.AutowireResolver;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.oasisopen.sca.annotation.Reference;

public class TypeAutowireResolver
implements AutowireResolver {
    private ContractMatcher matcher;

    public TypeAutowireResolver(@Reference ContractMatcher matcher) {
        this.matcher = matcher;
    }

    public List<LogicalService> resolve(LogicalReference logicalReference, ServiceContract contract, LogicalCompositeComponent composite) {
        ArrayList<LogicalService> candidates = new ArrayList<LogicalService>();
        Multiplicity refMultiplicity = logicalReference.getDefinition().getMultiplicity();
        boolean multiplicity = Multiplicity.ZERO_N.equals((Object)refMultiplicity) || Multiplicity.ONE_N.equals((Object)refMultiplicity);
        for (LogicalComponent child : composite.getComponents()) {
            if (logicalReference.getParent() == child) continue;
            if (this.validKey(logicalReference, child)) {
                for (LogicalService service : child.getServices()) {
                    ServiceContract targetContract = service.getServiceContract();
                    if (targetContract == null) {
                        throw new AssertionError((Object)("No service contract specified on service: " + service.getUri()));
                    }
                    MatchResult result = this.matcher.isAssignableFrom(contract, targetContract, false);
                    if (!result.isAssignable()) continue;
                    boolean intentsMatch = true;
                    for (QName intent : logicalReference.getIntents()) {
                        if (service.getIntents().contains(intent)) continue;
                        intentsMatch = false;
                        break;
                    }
                    if (!intentsMatch) continue;
                    candidates.add(service);
                    break;
                }
            }
            if (candidates.isEmpty() || multiplicity) continue;
            break;
        }
        return candidates;
    }

    private boolean validKey(LogicalReference logicalReference, LogicalComponent<?> target) {
        return !logicalReference.getDefinition().isKeyed() || target.getDefinition().getKey() != null || target.getDefinition().getComponentType().getKey() != null;
    }
}

