/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.wire;

import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.AbstractReference;
import org.fabric3.api.model.type.component.Autowire;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentReference;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.instantiator.AutowireInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.ReferenceNotFound;
import org.fabric3.spi.domain.instantiator.AutowireResolver;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

public class AutowireInstantiatorImpl
implements AutowireInstantiator {
    private AutowireResolver resolver;

    public AutowireInstantiatorImpl(@Reference AutowireResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void instantiate(LogicalComponent<?> component, InstantiationContext context) {
        this.resolveReferences(component, context);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent compositeComponent = (LogicalCompositeComponent)component;
            for (LogicalComponent child : compositeComponent.getComponents()) {
                this.instantiate(child, context);
            }
        }
    }

    private void resolveReferences(LogicalComponent<?> component, InstantiationContext context) {
        LogicalCompositeComponent parent = (LogicalCompositeComponent)component.getParent();
        for (LogicalReference reference : component.getReferences()) {
            boolean refMultiplicity;
            boolean scaTarget = this.isScaTarget(reference);
            if (scaTarget || reference.isConcreteBound()) continue;
            Multiplicity multiplicityValue = reference.getDefinition().getMultiplicity();
            boolean bl = refMultiplicity = multiplicityValue.equals((Object)Multiplicity.ZERO_N) || multiplicityValue.equals((Object)Multiplicity.ONE_N);
            if (!refMultiplicity && reference.isResolved()) continue;
            reference.setResolved(false);
            this.resolveReference(reference, parent, context);
        }
    }

    private boolean isScaTarget(LogicalReference reference) {
        boolean scaTarget = false;
        for (LogicalBinding binding : reference.getBindings()) {
            BindingDefinition definition = binding.getDefinition();
            if (!(definition instanceof SCABinding) || ((SCABinding)definition).getTarget() == null) continue;
            scaTarget = true;
            break;
        }
        return scaTarget;
    }

    private void resolveReference(LogicalReference logicalReference, LogicalCompositeComponent compositeComponent, InstantiationContext context) {
        boolean targeted;
        ServiceContract requiredContract;
        List targets;
        ComponentReference componentReference = logicalReference.getComponentReference();
        LogicalComponent component = (LogicalComponent)logicalReference.getParent();
        AbstractReference referenceDefinition = logicalReference.getDefinition();
        if (componentReference == null) {
            targets = referenceDefinition.getTargets();
            if (!targets.isEmpty()) {
                return;
            }
            if (logicalReference.isResolved()) {
                return;
            }
            requiredContract = logicalReference.getServiceContract();
            Autowire autowire = component.getAutowire();
            if (autowire == Autowire.ON) {
                this.instantiateWires(logicalReference, requiredContract, compositeComponent);
            }
        } else if (componentReference != null) {
            boolean resolved;
            targets = componentReference.getTargets();
            if (!targets.isEmpty()) {
                return;
            }
            if ((componentReference.getAutowire() == Autowire.ON || componentReference.getAutowire() == Autowire.INHERITED && component.getAutowire() == Autowire.ON) && !(resolved = this.instantiateWires(logicalReference, requiredContract = referenceDefinition.getServiceContract(), (LogicalCompositeComponent)component.getParent()))) {
                this.instantiateWires(logicalReference, requiredContract, compositeComponent);
            }
        }
        boolean bl = targeted = !logicalReference.getLeafReference().getWires().isEmpty();
        if (!targeted && referenceDefinition.isRequired() && !logicalReference.isConcreteBound()) {
            String referenceUri = logicalReference.getUri().toString();
            ReferenceNotFound error = new ReferenceNotFound("Unable to resolve reference " + referenceUri, logicalReference);
            context.addError(error);
        } else if (targeted) {
            logicalReference.setResolved(true);
        }
    }

    private boolean instantiateWires(LogicalReference logicalReference, ServiceContract contract, LogicalCompositeComponent composite) {
        List candidates = this.resolver.resolve(logicalReference, contract, composite);
        if (candidates.isEmpty()) {
            return false;
        }
        LogicalReference leafReference = logicalReference.getLeafReference();
        LogicalComponent parent = (LogicalComponent)leafReference.getParent();
        LogicalCompositeComponent parentComposite = (LogicalCompositeComponent)parent.getParent();
        List existingWires = parentComposite.getWires(leafReference);
        for (LogicalService target : candidates) {
            QName deployable = ((LogicalComponent)target.getParent()).getDeployable();
            boolean skip = false;
            for (LogicalWire existingWire : existingWires) {
                if (!target.equals(existingWire.getTarget())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            LogicalWire wire = new LogicalWire((LogicalComponent)parentComposite, leafReference, target, deployable, true);
            parentComposite.addWire(leafReference, wire);
            for (LogicalWire existingWire : existingWires) {
                if (LogicalState.PROVISIONED != existingWire.getTarget().getLeafComponent().getState()) continue;
                existingWire.setState(LogicalState.NEW);
            }
        }
        return true;
    }
}

