/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.promotion;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.fabric.domain.instantiator.AmbiguousReference;
import org.fabric3.fabric.domain.instantiator.AmbiguousService;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.NoServiceOnComponent;
import org.fabric3.fabric.domain.instantiator.PromotedComponentNotFound;
import org.fabric3.fabric.domain.instantiator.PromotionResolutionService;
import org.fabric3.fabric.domain.instantiator.ReferenceNotFound;
import org.fabric3.fabric.domain.instantiator.ServiceNotFound;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.util.UriHelper;

public class PromotionResolutionServiceImpl
implements PromotionResolutionService {
    @Override
    public void resolve(LogicalComponent<?> component, InstantiationContext context) {
        this.resolveReferences(component, context);
        this.resolveServices(component, context);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent compositeComponent = (LogicalCompositeComponent)component;
            for (LogicalComponent child : compositeComponent.getComponents()) {
                this.resolve(child, context);
            }
        }
    }

    private void resolveReferences(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalReference reference : component.getReferences()) {
            boolean refMultiplicity;
            Multiplicity multiplicityValue = reference.getDefinition().getMultiplicity();
            boolean bl = refMultiplicity = multiplicityValue.equals((Object)Multiplicity.ZERO_N) || multiplicityValue.equals((Object)Multiplicity.ONE_N);
            if (!refMultiplicity && reference.isResolved()) continue;
            reference.setResolved(false);
            this.resolve(reference, context);
        }
    }

    private void resolveServices(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalService logicalService : component.getServices()) {
            this.resolve(logicalService, context);
        }
    }

    void resolve(LogicalService logicalService, InstantiationContext context) {
        URI promotedUri = logicalService.getPromotedUri();
        if (promotedUri == null) {
            return;
        }
        URI promotedComponentUri = UriHelper.getDefragmentedName((URI)promotedUri);
        String promotedServiceName = promotedUri.getFragment();
        LogicalCompositeComponent composite = (LogicalCompositeComponent)logicalService.getParent();
        LogicalComponent promotedComponent = composite.getComponent(promotedComponentUri);
        if (promotedComponent == null) {
            PromotedComponentNotFound error = new PromotedComponentNotFound((Bindable)logicalService, promotedComponentUri);
            context.addError(error);
            return;
        }
        if (promotedServiceName == null) {
            Collection componentServices = promotedComponent.getServices();
            if (componentServices.size() == 0) {
                this.raiseNoServiceError(logicalService, promotedComponentUri, context);
            } else if (componentServices.size() == 2) {
                this.raiseAmbiguousServiceError(logicalService, promotedComponentUri, context);
            } else if (componentServices.size() > 2) {
                this.raiseAmbiguousServiceError(logicalService, promotedComponentUri, context);
            } else {
                logicalService.setPromotedUri(((LogicalService)componentServices.iterator().next()).getUri());
            }
        } else if (promotedComponent.getService(promotedServiceName) == null) {
            this.raiseServiceNotFoundError(logicalService, promotedComponentUri, promotedServiceName, context);
        }
    }

    void resolve(LogicalReference reference, InstantiationContext context) {
        List promotedUris = reference.getPromotedUris();
        for (int i = 0; i < promotedUris.size(); ++i) {
            URI promotedUri = (URI)promotedUris.get(i);
            URI promotedComponentUri = UriHelper.getDefragmentedName((URI)promotedUri);
            String promotedReferenceName = promotedUri.getFragment();
            LogicalCompositeComponent parent = (LogicalCompositeComponent)reference.getParent();
            LogicalComponent promotedComponent = parent.getComponent(promotedComponentUri);
            if (promotedComponent == null) {
                this.raiseComponentNotFoundError(reference, promotedComponentUri, context);
                return;
            }
            if (promotedReferenceName == null) {
                Collection componentReferences = promotedComponent.getReferences();
                if (componentReferences.size() == 0) {
                    this.raiseReferenceNotFoundError(promotedReferenceName, promotedComponentUri, reference, context);
                    return;
                }
                if (componentReferences.size() > 1) {
                    AmbiguousReference error = new AmbiguousReference(reference, promotedComponentUri);
                    context.addError(error);
                    return;
                }
                LogicalReference promotedReference = (LogicalReference)componentReferences.iterator().next();
                reference.setPromotedUri(i, promotedReference.getUri());
                promotedReference.setResolved(true);
                continue;
            }
            LogicalReference promotedReference = promotedComponent.getReference(promotedReferenceName);
            if (promotedReference == null) {
                this.raiseReferenceNotFoundError(promotedReferenceName, promotedComponentUri, reference, context);
                return;
            }
            promotedReference.setResolved(true);
        }
    }

    private void raiseReferenceNotFoundError(String referenceName, URI uri, LogicalReference reference, InstantiationContext context) {
        String msg = "Reference " + referenceName + " not found on component " + uri;
        ReferenceNotFound error = new ReferenceNotFound(msg, reference);
        context.addError(error);
    }

    private void raiseComponentNotFoundError(LogicalReference reference, URI uri, InstantiationContext context) {
        PromotedComponentNotFound error = new PromotedComponentNotFound((Bindable)reference, uri);
        context.addError(error);
    }

    private void raiseServiceNotFoundError(LogicalService service, URI uri, String name, InstantiationContext context) {
        String message = "Service " + name + " promoted from " + service.getUri() + " not found on component " + uri;
        ServiceNotFound error = new ServiceNotFound(message, (Bindable)service);
        context.addError(error);
    }

    private void raiseNoServiceError(LogicalService service, URI uri, InstantiationContext context) {
        LogicalComponent parent = (LogicalComponent)service.getParent();
        String msg = "No services available on component: " + uri;
        NoServiceOnComponent error = new NoServiceOnComponent(msg, parent);
        context.addError(error);
    }

    private void raiseAmbiguousServiceError(LogicalService service, URI uri, InstantiationContext context) {
        String msg = "The promoted service " + service.getUri() + " must explicitly specify the service it is promoting on component " + uri + " as the component has more than one service";
        AmbiguousService error = new AmbiguousService(msg, (Bindable)service);
        context.addError(error);
    }
}

