/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.instantiator.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.model.type.component.AbstractReference;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentReference;
import org.fabric3.api.model.type.component.ComponentService;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.CompositeImplementation;
import org.fabric3.api.model.type.component.CompositeReference;
import org.fabric3.api.model.type.component.CompositeService;
import org.fabric3.api.model.type.component.ResourceDefinition;
import org.fabric3.fabric.domain.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.ChannelInstantiator;
import org.fabric3.fabric.domain.instantiator.CompositeComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.InstantiationContext;
import org.fabric3.fabric.domain.instantiator.WireInstantiator;
import org.fabric3.fabric.domain.instantiator.component.AbstractComponentInstantiator;
import org.fabric3.fabric.domain.instantiator.component.DuplicateComponent;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class CompositeComponentInstantiatorImpl
extends AbstractComponentInstantiator
implements CompositeComponentInstantiator {
    private AtomicComponentInstantiator atomicInstantiator;
    private WireInstantiator wireInstantiator;
    private ChannelInstantiator channelInstantiator;
    private boolean componentTypeOverride;

    @Property(required=false)
    @Source(value="$systemConfig//f3:sca/@componentTypeOverride")
    public void setComponentTypeOverride(boolean componentTypeOverride) {
        this.componentTypeOverride = componentTypeOverride;
    }

    @Constructor
    public CompositeComponentInstantiatorImpl(@Reference AtomicComponentInstantiator atomicInstantiator, @Reference WireInstantiator wireInstantiator, @Reference ChannelInstantiator channelInstantiator) {
        this.atomicInstantiator = atomicInstantiator;
        this.wireInstantiator = wireInstantiator;
        this.channelInstantiator = channelInstantiator;
    }

    public CompositeComponentInstantiatorImpl(AtomicComponentInstantiator atomicInstantiator, WireInstantiator wireInstantiator) {
        this(atomicInstantiator, wireInstantiator, null);
    }

    public LogicalComponent<CompositeImplementation> instantiate(ComponentDefinition<CompositeImplementation> definition, LogicalCompositeComponent parent, InstantiationContext context) {
        URI uri = URI.create(parent.getUri() + "/" + definition.getName());
        Composite composite = (Composite)((CompositeImplementation)definition.getImplementation()).getComponentType();
        LogicalCompositeComponent component = new LogicalCompositeComponent(uri, definition, parent);
        if (this.componentTypeOverride) {
            component.getPolicySets().removeAll(definition.getPolicySets());
        }
        this.initializeProperties((LogicalComponent<?>)component, definition, context);
        this.instantiateChildComponents(component, composite, context);
        this.instantiateCompositeServices(component, composite);
        this.wireInstantiator.instantiateCompositeWires(composite, component, context);
        this.instantiateCompositeReferences(component, composite);
        this.instantiateResources(component, composite);
        this.wireInstantiator.instantiateCompositeWires(composite, component, context);
        if (this.channelInstantiator != null) {
            this.channelInstantiator.instantiateChannels(composite, component, context);
        }
        if (parent.getComponent(uri) != null) {
            DuplicateComponent error = new DuplicateComponent(uri, parent);
            context.addError(error);
        }
        parent.addComponent((LogicalComponent)component);
        return component;
    }

    private void instantiateChildComponents(LogicalCompositeComponent component, Composite composite, InstantiationContext context) {
        ArrayList<LogicalComponent<CompositeImplementation>> children = new ArrayList<LogicalComponent<CompositeImplementation>>();
        for (ComponentDefinition componentDefinition : composite.getComponents().values()) {
            Object childComponent = componentDefinition.getImplementation() instanceof CompositeImplementation ? this.instantiate((ComponentDefinition<CompositeImplementation>)componentDefinition, component, context) : this.atomicInstantiator.instantiate(componentDefinition, component, context);
            component.addComponent(childComponent);
            children.add((LogicalComponent<CompositeImplementation>)childComponent);
        }
        for (LogicalComponent logicalComponent : children) {
            this.wireInstantiator.instantiateReferenceWires(logicalComponent, context);
        }
    }

    private void instantiateCompositeServices(LogicalCompositeComponent component, Composite composite) {
        ComponentDefinition definition = component.getDefinition();
        String uriBase = component.getUri().toString() + "/";
        for (CompositeService service : composite.getCompositeServices().values()) {
            String name = service.getName();
            URI serviceUri = component.getUri().resolve('#' + name);
            LogicalService logicalService = new LogicalService(serviceUri, (AbstractService)service, (LogicalComponent)component);
            logicalService.setPromotedUri(URI.create(uriBase + service.getPromote()));
            List serviceBindings = service.getBindings();
            for (BindingDefinition binding : serviceBindings) {
                LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addBinding(logicalBinding);
            }
            List serviceCallbackBindings = service.getCallbackBindings();
            for (BindingDefinition binding : serviceCallbackBindings) {
                LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addCallbackBinding(logicalBinding);
            }
            ComponentService componentService = (ComponentService)definition.getServices().get(name);
            if (componentService != null) {
                if (!componentService.getBindings().isEmpty()) {
                    ArrayList<LogicalBinding> bindings = new ArrayList<LogicalBinding>();
                    for (BindingDefinition binding : componentService.getBindings()) {
                        LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                        bindings.add(logicalBinding);
                    }
                    logicalService.overrideBindings(bindings);
                    ArrayList<LogicalBinding> callbackBindings = new ArrayList<LogicalBinding>();
                    for (BindingDefinition callbackBinding : componentService.getCallbackBindings()) {
                        LogicalBinding logicalBinding = new LogicalBinding(callbackBinding, (Bindable)logicalService);
                        callbackBindings.add(logicalBinding);
                    }
                    logicalService.overrideCallbackBindings(callbackBindings);
                }
                logicalService.addIntents(componentService.getIntents());
            }
            component.addService(logicalService);
        }
    }

    private void instantiateCompositeReferences(LogicalCompositeComponent component, Composite composite) {
        ComponentDefinition definition = component.getDefinition();
        String uriBase = component.getUri().toString() + "/";
        for (CompositeReference reference : composite.getCompositeReferences().values()) {
            String name = reference.getName();
            URI referenceUri = component.getUri().resolve('#' + name);
            LogicalReference logicalReference = new LogicalReference(referenceUri, (AbstractReference)reference, (LogicalComponent)component);
            List referenceBindings = reference.getBindings();
            for (BindingDefinition binding : referenceBindings) {
                LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                logicalReference.addBinding(logicalBinding);
            }
            List callbackBindings = reference.getCallbackBindings();
            for (BindingDefinition binding : callbackBindings) {
                LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                logicalReference.addCallbackBinding(logicalBinding);
            }
            for (URI promotedUri : reference.getPromotedUris()) {
                URI resolvedUri = URI.create(uriBase + promotedUri.toString());
                logicalReference.addPromotedUri(resolvedUri);
            }
            ComponentReference componentReference = (ComponentReference)definition.getReferences().get(name);
            if (componentReference != null) {
                if (!componentReference.getBindings().isEmpty()) {
                    ArrayList<LogicalBinding> bindings = new ArrayList<LogicalBinding>();
                    List overrideBindings = componentReference.getBindings();
                    for (BindingDefinition binding : overrideBindings) {
                        LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                        bindings.add(logicalBinding);
                    }
                    logicalReference.overrideBindings(bindings);
                }
                logicalReference.addIntents(componentReference.getIntents());
            }
            component.addReference(logicalReference);
        }
    }

    private void instantiateResources(LogicalCompositeComponent component, Composite composite) {
        for (ResourceDefinition definition : composite.getResources()) {
            LogicalResource resource = new LogicalResource(definition, component);
            component.addResource(resource);
        }
    }
}

