/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.AbstractReference;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.ResourceReferenceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.domain.generator.GeneratorNotFoundException;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.wire.CallbackServiceNotFoundException;
import org.fabric3.fabric.domain.generator.wire.PhysicalOperationGenerator;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.component.ComponentGenerator;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.domain.generator.policy.PolicyResolver;
import org.fabric3.spi.domain.generator.policy.PolicyResult;
import org.fabric3.spi.domain.generator.resource.ResourceReferenceGenerator;
import org.fabric3.spi.domain.generator.wire.WireBindingGenerator;
import org.fabric3.spi.domain.generator.wire.WireGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.fabric3.spi.model.type.remote.RemoteServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class WireGeneratorImpl
implements WireGenerator {
    private GeneratorRegistry generatorRegistry;
    private ContractMatcher matcher;
    private PolicyResolver policyResolver;
    private PhysicalOperationGenerator operationGenerator;

    public WireGeneratorImpl(@Reference GeneratorRegistry generatorRegistry, @Reference ContractMatcher matcher, @Reference PolicyResolver policyResolver, @Reference PhysicalOperationGenerator operationGenerator) {
        this.generatorRegistry = generatorRegistry;
        this.matcher = matcher;
        this.policyResolver = policyResolver;
        this.operationGenerator = operationGenerator;
    }

    public <T extends BindingDefinition> PhysicalWireDefinition generateBoundService(LogicalBinding<T> binding, URI callbackUri) throws GenerationException {
        this.checkService(binding);
        LogicalService service = (LogicalService)binding.getParent();
        LogicalComponent component = service.getLeafComponent();
        ServiceContract contract = service.getLeafService().getServiceContract();
        List operations = service.getOperations();
        PolicyResult policyResult = this.policyResolver.resolvePolicies(binding);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(component);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateTarget(service, targetPolicy);
        targetDefinition.setClassLoaderId(((LogicalComponent)service.getParent()).getDefinition().getContributionUri());
        targetDefinition.setCallbackUri(callbackUri);
        WireBindingGenerator<T> sourceGenerator = this.getGenerator(binding);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateSource(binding, contract, operations, sourcePolicy);
        sourceDefinition.setClassLoaderId(((LogicalComponent)service.getParent()).getDefinition().getContributionUri());
        Set<PhysicalOperationDefinition> physicalOperations = this.operationGenerator.generateOperations(operations, true, policyResult);
        PhysicalWireDefinition pwd = new PhysicalWireDefinition(sourceDefinition, targetDefinition, physicalOperations);
        boolean optimizable = sourceDefinition.isOptimizable() && targetDefinition.isOptimizable() && this.checkOptimization(contract, physicalOperations);
        pwd.setOptimizable(optimizable);
        return pwd;
    }

    public <T extends BindingDefinition> PhysicalWireDefinition generateBoundServiceCallback(LogicalBinding<T> binding) throws GenerationException {
        this.checkService(binding);
        LogicalService service = (LogicalService)binding.getParent();
        LogicalComponent component = service.getLeafComponent();
        ServiceContract contract = service.getLeafService().getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        List operations = service.getCallbackOperations();
        PolicyResult policyResult = this.policyResolver.resolveCallbackPolicies(binding);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateCallbackSource(service, sourcePolicy);
        sourceDefinition.setClassLoaderId(component.getDefinition().getContributionUri());
        WireBindingGenerator<T> bindingGenerator = this.getGenerator(binding);
        PhysicalWireTargetDefinition targetDefinition = bindingGenerator.generateTarget(binding, callbackContract, operations, targetPolicy);
        targetDefinition.setCallback(true);
        targetDefinition.setClassLoaderId(((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri());
        Set<PhysicalOperationDefinition> physicalOperations = this.operationGenerator.generateOperations(operations, true, policyResult);
        return new PhysicalWireDefinition(sourceDefinition, targetDefinition, physicalOperations);
    }

    public <T extends BindingDefinition> PhysicalWireDefinition generateBoundReference(LogicalBinding<T> binding) throws GenerationException {
        this.checkReference(binding);
        LogicalReference reference = (LogicalReference)binding.getParent();
        LogicalComponent component = (LogicalComponent)reference.getParent();
        ServiceContract contract = reference.getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        List operations = reference.getOperations();
        PolicyResult policyResult = this.policyResolver.resolvePolicies(binding);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateSource(reference, sourcePolicy);
        String key = binding.getDefinition().getName();
        sourceDefinition.setKey(key);
        sourceDefinition.setClassLoaderId(component.getDefinition().getContributionUri());
        WireBindingGenerator<T> targetGenerator = this.getGenerator(binding);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateTarget(binding, contract, operations, targetPolicy);
        if (callbackContract != null) {
            AbstractReference referenceDefinition = reference.getDefinition();
            URI callbackUri = this.generateCallbackUri(component, callbackContract, referenceDefinition.getName());
            targetDefinition.setCallbackUri(callbackUri);
        }
        targetDefinition.setClassLoaderId(((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri());
        Set<PhysicalOperationDefinition> physicalOperations = this.operationGenerator.generateOperations(operations, true, policyResult);
        return new PhysicalWireDefinition(sourceDefinition, targetDefinition, physicalOperations);
    }

    public <T extends BindingDefinition> PhysicalWireDefinition generateBoundReferenceCallback(LogicalBinding<T> binding) throws GenerationException {
        this.checkReference(binding);
        LogicalReference reference = (LogicalReference)binding.getParent();
        LogicalComponent component = (LogicalComponent)reference.getParent();
        ServiceContract contract = reference.getServiceContract();
        ServiceContract callbackContract = contract.getCallbackContract();
        LogicalService callbackService = component.getService(callbackContract.getInterfaceName());
        List operations = reference.getCallbackOperations();
        PolicyResult policyResult = this.policyResolver.resolveCallbackPolicies(binding);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        WireBindingGenerator<T> sourceGenerator = this.getGenerator(binding);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateSource(binding, callbackContract, operations, targetPolicy);
        sourceDefinition.setClassLoaderId(((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri());
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(component);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateTarget(callbackService, sourcePolicy);
        targetDefinition.setClassLoaderId(((LogicalComponent)callbackService.getParent()).getDefinition().getContributionUri());
        targetDefinition.setCallback(true);
        Set<PhysicalOperationDefinition> operation = this.operationGenerator.generateOperations(operations, true, policyResult);
        return new PhysicalWireDefinition(sourceDefinition, targetDefinition, operation);
    }

    public PhysicalWireDefinition generateWire(LogicalWire wire) throws GenerationException {
        if (this.isLocal(wire)) {
            return this.generateLocalWire(wire);
        }
        return this.generateRemoteWire(wire);
    }

    public PhysicalWireDefinition generateWireCallback(LogicalWire wire) throws GenerationException {
        if (this.isLocal(wire)) {
            return this.generateLocalWireCallback(wire);
        }
        return this.generateRemoteWireCallback(wire);
    }

    public <T extends ResourceReferenceDefinition> PhysicalWireDefinition generateResource(LogicalResourceReference<T> resourceReference) throws GenerationException {
        ResourceReferenceDefinition resourceDefinition = resourceReference.getDefinition();
        LogicalComponent component = (LogicalComponent)resourceReference.getParent();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(component);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateResourceSource(resourceReference);
        sourceDefinition.setClassLoaderId(component.getDefinition().getContributionUri());
        ResourceReferenceGenerator<ResourceReferenceDefinition> targetGenerator = this.getGenerator(resourceDefinition);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateWireTarget(resourceReference);
        targetDefinition.setClassLoaderId(((LogicalComponent)resourceReference.getParent()).getDefinition().getContributionUri());
        boolean optimizable = targetDefinition.isOptimizable();
        List sourceOperations = resourceReference.getOperations();
        Set<PhysicalOperationDefinition> operations = this.operationGenerator.generateOperations(sourceOperations, false, null);
        PhysicalWireDefinition pwd = new PhysicalWireDefinition(sourceDefinition, targetDefinition, operations);
        pwd.setOptimizable(optimizable);
        return pwd;
    }

    private boolean isLocal(LogicalWire wire) {
        String targetZone;
        String sourceZone = ((LogicalComponent)wire.getSource().getParent()).getZone();
        return !(!sourceZone.equals(targetZone = ((LogicalComponent)wire.getTarget().getParent()).getZone()) || wire.getSourceBinding() != null && !(wire.getSourceBinding().getDefinition() instanceof SCABinding) || wire.getTargetBinding() != null && !(wire.getTargetBinding().getDefinition() instanceof SCABinding));
    }

    private PhysicalWireDefinition generateLocalWire(LogicalWire wire) throws GenerationException {
        Set<PhysicalOperationDefinition> operations;
        List sourceOperations;
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget().getLeafService();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        AbstractReference referenceDefinition = reference.getDefinition();
        ServiceContract referenceContract = reference.getServiceContract();
        PolicyResult policyResult = this.policyResolver.resolveLocalPolicies(wire);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(source);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateSource(reference, sourcePolicy);
        sourceDefinition.setClassLoaderId(source.getDefinition().getContributionUri());
        String key = this.getKey(target);
        sourceDefinition.setKey(key);
        int order = this.getOrder(target);
        sourceDefinition.setOrder(order);
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(target);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateTarget(service, targetPolicy);
        targetDefinition.setClassLoaderId(target.getDefinition().getContributionUri());
        ServiceContract serviceContract = service.getServiceContract();
        ServiceContract callbackContract = serviceContract.getCallbackContract();
        if (callbackContract != null) {
            URI callbackUri = this.generateCallbackUri(source, callbackContract, referenceDefinition.getName());
            targetDefinition.setCallbackUri(callbackUri);
        }
        if (referenceContract.getClass().equals(serviceContract.getClass())) {
            sourceOperations = reference.getOperations();
            operations = this.operationGenerator.generateOperations(sourceOperations, false, policyResult);
        } else {
            sourceOperations = reference.getOperations();
            List targetOperations = service.getOperations();
            operations = this.operationGenerator.generateOperations(sourceOperations, targetOperations, false, policyResult);
        }
        QName sourceDeployable = source.getDeployable();
        QName targetDeployable = target.getDeployable();
        PhysicalWireDefinition pwd = new PhysicalWireDefinition(sourceDefinition, sourceDeployable, targetDefinition, targetDeployable, operations);
        boolean optimizable = sourceDefinition.isOptimizable() && targetDefinition.isOptimizable() && this.checkOptimization(referenceContract, operations);
        pwd.setOptimizable(optimizable);
        return pwd;
    }

    private <BD extends BindingDefinition> PhysicalWireDefinition generateRemoteWire(LogicalWire wire) throws GenerationException {
        Set<PhysicalOperationDefinition> physicalOperations;
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent source = (LogicalComponent)reference.getParent();
        LogicalComponent target = service.getLeafComponent();
        AbstractReference referenceDefinition = reference.getDefinition();
        ServiceContract referenceContract = reference.getServiceContract();
        ServiceContract serviceContract = service.getServiceContract();
        ServiceContract callbackContract = serviceContract.getCallbackContract();
        PolicyResult policyResult = this.policyResolver.resolveRemotePolicies(wire);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator((LogicalComponent)reference.getParent());
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateSource(reference, sourcePolicy);
        sourceDefinition.setClassLoaderId(source.getDefinition().getContributionUri());
        String key = this.getKey(source);
        sourceDefinition.setKey(key);
        int order = this.getOrder(source);
        sourceDefinition.setOrder(order);
        LogicalBinding serviceBinding = wire.getTargetBinding();
        WireBindingGenerator targetGenerator = this.getGenerator(serviceBinding);
        List sourceOperations = reference.getOperations();
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateServiceBindingTarget(serviceBinding, serviceContract, sourceOperations, targetPolicy);
        targetDefinition.setClassLoaderId(source.getDefinition().getContributionUri());
        if (callbackContract != null) {
            URI callbackUri = this.generateCallbackUri(source, callbackContract, referenceDefinition.getName());
            targetDefinition.setCallbackUri(callbackUri);
        }
        if (referenceContract.getClass().equals(serviceContract.getClass()) || serviceContract instanceof RemoteServiceContract) {
            physicalOperations = this.operationGenerator.generateOperations(sourceOperations, true, policyResult);
        } else {
            List targetOperations = service.getOperations();
            physicalOperations = this.operationGenerator.generateOperations(sourceOperations, targetOperations, true, policyResult);
        }
        QName sourceDeployable = source.getDeployable();
        QName targetDeployable = target.getDeployable();
        return new PhysicalWireDefinition(sourceDefinition, sourceDeployable, targetDefinition, targetDeployable, physicalOperations);
    }

    private PhysicalWireDefinition generateLocalWireCallback(LogicalWire wire) throws GenerationException {
        Set<PhysicalOperationDefinition> callbackOperations;
        LogicalReference reference = wire.getSource();
        LogicalService service = wire.getTarget();
        LogicalComponent targetComponent = (LogicalComponent)reference.getParent();
        ServiceContract referenceCallbackContract = reference.getServiceContract().getCallbackContract();
        LogicalService callbackService = targetComponent.getService(referenceCallbackContract.getInterfaceName());
        LogicalComponent sourceComponent = service.getLeafComponent();
        PolicyResult policyResult = this.policyResolver.resolveLocalCallbackPolicies(wire);
        EffectivePolicy sourcePolicy = policyResult.getSourcePolicy();
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
        if (referenceCallbackContract.getClass().equals(callbackContract.getClass())) {
            List operations = service.getCallbackOperations();
            callbackOperations = this.operationGenerator.generateOperations(operations, false, policyResult);
        } else {
            List targetOperations = callbackService.getOperations();
            List sourceOperations = service.getCallbackOperations();
            callbackOperations = this.operationGenerator.generateOperations(targetOperations, sourceOperations, false, policyResult);
        }
        ComponentGenerator<LogicalComponent> sourceGenerator = this.getGenerator(sourceComponent);
        PhysicalWireSourceDefinition sourceDefinition = sourceGenerator.generateCallbackSource(service, sourcePolicy);
        sourceDefinition.setClassLoaderId(sourceComponent.getDefinition().getContributionUri());
        ComponentGenerator<LogicalComponent> targetGenerator = this.getGenerator(targetComponent);
        PhysicalWireTargetDefinition targetDefinition = targetGenerator.generateTarget(callbackService, targetPolicy);
        targetDefinition.setClassLoaderId(targetComponent.getDefinition().getContributionUri());
        targetDefinition.setCallback(true);
        PhysicalWireDefinition pwd = new PhysicalWireDefinition(sourceDefinition, targetDefinition, callbackOperations);
        pwd.setOptimizable(false);
        return pwd;
    }

    private PhysicalWireDefinition generateRemoteWireCallback(LogicalWire wire) throws GenerationException {
        LogicalReference reference = wire.getSource();
        LogicalComponent target = (LogicalComponent)reference.getParent();
        ServiceContract referenceContract = reference.getServiceContract();
        ServiceContract referenceCallbackContract = referenceContract.getCallbackContract();
        if (reference.getCallbackBindings().isEmpty()) {
            throw new GenerationException("Callback binding not set");
        }
        LogicalBinding referenceBinding = (LogicalBinding)reference.getCallbackBindings().get(0);
        LogicalService callbackService = target.getService(referenceCallbackContract.getInterfaceName());
        List operations = reference.getCallbackOperations();
        PolicyResult policyResult = this.policyResolver.resolveRemoteCallbackPolicies(wire);
        EffectivePolicy targetPolicy = policyResult.getTargetPolicy();
        WireBindingGenerator bindingGenerator = this.getGenerator(referenceBinding);
        PhysicalWireSourceDefinition sourceDefinition = bindingGenerator.generateSource(referenceBinding, referenceCallbackContract, operations, targetPolicy);
        URI contributionUri = target.getDefinition().getContributionUri();
        sourceDefinition.setClassLoaderId(contributionUri);
        ComponentGenerator<LogicalComponent> componentGenerator = this.getGenerator(target);
        PhysicalWireTargetDefinition targetDefinition = componentGenerator.generateTarget(callbackService, targetPolicy);
        targetDefinition.setClassLoaderId(target.getDefinition().getContributionUri());
        Set<PhysicalOperationDefinition> physicalOperations = this.operationGenerator.generateOperations(operations, true, policyResult);
        return new PhysicalWireDefinition(sourceDefinition, targetDefinition, physicalOperations);
    }

    private <S extends LogicalComponent<?>> URI generateCallbackUri(S source, ServiceContract contract, String referenceName) throws GenerationException {
        LogicalService candidate = null;
        for (LogicalService entry : source.getServices()) {
            MatchResult result = this.matcher.isAssignableFrom(contract, entry.getServiceContract(), false);
            if (!result.isAssignable()) continue;
            candidate = entry;
            break;
        }
        if (candidate == null) {
            String name = contract.getInterfaceName();
            URI uri = source.getUri();
            throw new CallbackServiceNotFoundException("Callback service not found: " + name + " on component: " + uri + " originating from reference :" + referenceName);
        }
        return URI.create(source.getUri().toString() + "#" + candidate.getDefinition().getName());
    }

    private boolean checkOptimization(ServiceContract serviceContract, Set<PhysicalOperationDefinition> operationDefinitions) {
        if (serviceContract.isRemotable()) {
            return false;
        }
        for (PhysicalOperationDefinition operation : operationDefinitions) {
            if (operation.getInterceptors().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String getKey(LogicalComponent component) {
        Implementation implementation;
        String key = component.getDefinition().getKey();
        if (key == null && (implementation = component.getDefinition().getImplementation()) != null && implementation.getComponentType() != null) {
            key = implementation.getComponentType().getKey();
        }
        return key;
    }

    private int getOrder(LogicalComponent component) {
        ComponentDefinition definition;
        Implementation implementation;
        int order = component.getDefinition().getOrder();
        if (order == Integer.MIN_VALUE && (implementation = (definition = component.getDefinition()).getImplementation()) != null && implementation.getComponentType() != null) {
            order = implementation.getComponentType().getOrder();
        }
        return order;
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) throws GeneratorNotFoundException {
        Implementation implementation = component.getDefinition().getImplementation();
        return this.generatorRegistry.getComponentGenerator(implementation.getClass());
    }

    private <T extends ResourceReferenceDefinition> ResourceReferenceGenerator<T> getGenerator(T definition) throws GeneratorNotFoundException {
        return this.generatorRegistry.getResourceReferenceGenerator(definition.getClass());
    }

    private <T extends BindingDefinition> WireBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getBindingGenerator(binding.getDefinition().getClass());
    }

    private void checkService(LogicalBinding<?> binding) {
        if (!(binding.getParent() instanceof LogicalService)) {
            throw new AssertionError((Object)("Expected " + LogicalService.class.getName() + " as parent to binding"));
        }
    }

    private void checkReference(LogicalBinding binding) {
        if (!(binding.getParent() instanceof LogicalReference)) {
            throw new AssertionError((Object)("Expected " + LogicalReference.class.getName() + " as parent to binding"));
        }
    }
}

