/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.wire.WireGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ResourceReferenceCommandGenerator
implements CommandGenerator {
    private WireGenerator wireGenerator;

    public ResourceReferenceCommandGenerator(@Reference WireGenerator wireGenerator) {
        this.wireGenerator = wireGenerator;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent || component.getResourceReferences().isEmpty() || component.getState() != LogicalState.NEW && incremental) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand(component.getUri());
        for (LogicalResourceReference resourceReference : component.getResourceReferences()) {
            AttachWireCommand attachWireCommand = new AttachWireCommand();
            PhysicalWireDefinition pwd = this.wireGenerator.generateResource(resourceReference);
            attachWireCommand.setPhysicalWireDefinition(pwd);
            command.add(attachWireCommand);
        }
        return command;
    }
}

