/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.wire.CallbackBindingGenerator;
import org.fabric3.spi.domain.generator.wire.WireGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

public class ReferenceCommandGenerator
implements CommandGenerator {
    private WireGenerator wireGenerator;
    private Map<Class<?>, CallbackBindingGenerator> generators = Collections.emptyMap();

    public ReferenceCommandGenerator(@Reference WireGenerator wireGenerator) {
        this.wireGenerator = wireGenerator;
    }

    @Reference(required=false)
    public void setCallbackBindingGenerators(Map<Class<?>, CallbackBindingGenerator> generators) {
        this.generators = generators;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand(component.getUri());
        for (LogicalReference reference : component.getReferences()) {
            if (!reference.getWires().isEmpty()) {
                this.generateWires(reference, command, incremental);
                continue;
            }
            this.generateBindings(reference, component, incremental, command);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generateBindings(LogicalReference reference, LogicalComponent<?> component, boolean incremental, ConnectionCommand command) throws GenerationException {
        boolean bindings;
        boolean reinjection = this.isBoundReinjection(reference, incremental);
        for (LogicalBinding logicalBinding : reference.getBindings()) {
            if (logicalBinding.getDefinition() instanceof SCABinding) continue;
            this.generateBinding(component, logicalBinding, command, incremental, reinjection, false);
        }
        if (reference.getServiceContract().getCallbackContract() != null && (bindings = reference.isConcreteBound())) {
            List callbackBindings = reference.getCallbackBindings();
            if (callbackBindings.isEmpty()) {
                this.generateCallbackBindings(reference);
            }
            if (callbackBindings.size() != 1) {
                String uri = reference.getUri().toString();
                throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on reference: " + uri);
            }
            LogicalBinding callbackBinding = (LogicalBinding)callbackBindings.get(0);
            this.generateBinding(component, callbackBinding, command, incremental, reinjection, true);
        }
    }

    private void generateBinding(LogicalComponent<?> component, LogicalBinding<?> logicalBinding, ConnectionCommand command, boolean incremental, boolean reinjection, boolean callback) throws GenerationException {
        if (LogicalState.MARKED == component.getState() || LogicalState.MARKED == logicalBinding.getState()) {
            PhysicalWireDefinition wireDefinition = callback ? this.wireGenerator.generateBoundReferenceCallback(logicalBinding) : this.wireGenerator.generateBoundReference(logicalBinding);
            DetachWireCommand wireCommand = new DetachWireCommand();
            wireCommand.setPhysicalWireDefinition(wireDefinition);
            command.add(wireCommand);
        } else if (LogicalState.NEW == logicalBinding.getState() || !incremental || reinjection) {
            PhysicalWireDefinition wireDefinition = callback ? this.wireGenerator.generateBoundReferenceCallback(logicalBinding) : this.wireGenerator.generateBoundReference(logicalBinding);
            AttachWireCommand wireCommand = new AttachWireCommand();
            wireCommand.setPhysicalWireDefinition(wireDefinition);
            command.add(wireCommand);
        }
    }

    private void generateWires(LogicalReference reference, ConnectionCommand command, boolean incremental) throws GenerationException {
        boolean reinjection = this.isWireReinjection(reference, incremental);
        for (LogicalWire wire : reference.getWires()) {
            AttachWireCommand attachCommand;
            DetachWireCommand detachCommand;
            PhysicalWireDefinition pwd;
            LogicalService service = wire.getTarget();
            LogicalComponent targetComponent = service.getLeafComponent();
            if (!reinjection && wire.getState() == LogicalState.PROVISIONED && targetComponent.getState() != LogicalState.MARKED && incremental) continue;
            boolean attach = true;
            if (targetComponent.getState() == LogicalState.MARKED || wire.getState() == LogicalState.MARKED) {
                attach = false;
                pwd = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateBoundReference(wire.getSourceBinding()) : this.wireGenerator.generateWire(wire);
                detachCommand = new DetachWireCommand();
                detachCommand.setPhysicalWireDefinition(pwd);
                command.add(detachCommand);
            } else if (reinjection && targetComponent.getState() == LogicalState.NEW || !incremental || wire.getState() == LogicalState.NEW || targetComponent.getState() == LogicalState.NEW) {
                pwd = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateBoundReference(wire.getSourceBinding()) : this.wireGenerator.generateWire(wire);
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(pwd);
                command.add(attachCommand);
            }
            if (reference.getServiceContract().getCallbackContract() == null) continue;
            pwd = wire.getSourceBinding() != null && wire.getTargetBinding() == null ? this.wireGenerator.generateBoundReferenceCallback((LogicalBinding)reference.getCallbackBindings().get(0)) : this.wireGenerator.generateWireCallback(wire);
            if (attach) {
                attachCommand = new AttachWireCommand();
                attachCommand.setPhysicalWireDefinition(pwd);
                command.add(attachCommand);
                continue;
            }
            detachCommand = new DetachWireCommand();
            detachCommand.setPhysicalWireDefinition(pwd);
            command.add(detachCommand);
        }
    }

    private void generateCallbackBindings(LogicalReference reference) throws GenerationException {
        for (LogicalBinding logicalBinding : reference.getBindings()) {
            if (logicalBinding.getDefinition() instanceof SCABinding) continue;
            CallbackBindingGenerator generator = this.generators.get(logicalBinding.getDefinition().getClass());
            if (generator == null) {
                throw new GenerationException("Callback generator not found for:" + logicalBinding.getDefinition().getType());
            }
            BindingDefinition definition = generator.generateReferenceCallback(logicalBinding);
            definition.setParent((ModelObject)reference.getDefinition());
            LogicalBinding logicalCallback = new LogicalBinding(definition, (Bindable)reference);
            reference.addCallbackBinding(logicalCallback);
        }
    }

    private boolean isWireReinjection(LogicalReference logicalReference, boolean incremental) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (incremental && multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalWire wire : logicalReference.getWires()) {
                LogicalComponent targetComponent = wire.getTarget().getLeafComponent();
                if (wire.getState() != LogicalState.NEW && wire.getState() != LogicalState.MARKED && targetComponent.getState() != LogicalState.NEW && targetComponent.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBoundReinjection(LogicalReference logicalReference, boolean incremental) {
        Multiplicity multiplicity = logicalReference.getDefinition().getMultiplicity();
        if (incremental && multiplicity == Multiplicity.ZERO_N || multiplicity == Multiplicity.ONE_N) {
            for (LogicalBinding binding : logicalReference.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                return true;
            }
        }
        return false;
    }
}

