/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.spi.contract.OperationNotFoundException;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.type.xsd.XSDComplexType;
import org.fabric3.spi.model.type.xsd.XSDType;

public class OperationResolverImpl
implements OperationResolver {
    public LogicalOperation resolve(LogicalOperation source, List<LogicalOperation> targets) throws OperationNotFoundException {
        Operation sourceDefinition = source.getDefinition();
        for (LogicalOperation target : targets) {
            DataType targetOutputType;
            Operation targetDefinition = target.getDefinition();
            if (!sourceDefinition.getName().equals(targetDefinition.getName()) && !sourceDefinition.getWsdlName().equals(targetDefinition.getWsdlName())) continue;
            List sourceInputTypes = sourceDefinition.getInputTypes();
            List targetInputTypes = targetDefinition.getInputTypes();
            DataType sourceOutputType = sourceDefinition.getOutputType();
            if (sourceOutputType.equals((Object)(targetOutputType = targetDefinition.getOutputType())) && sourceInputTypes.equals(targetDefinition.getInputTypes())) {
                return target;
            }
            if (sourceInputTypes.size() != targetInputTypes.size()) continue;
            boolean equals = true;
            for (int i = 0; i < sourceInputTypes.size(); ++i) {
                DataType sourceType = (DataType)sourceInputTypes.get(i);
                QName sourceXsdType = sourceType.getXsdType();
                DataType targetType = (DataType)targetInputTypes.get(i);
                QName targetXsdType = targetType.getXsdType();
                if (sourceXsdType != null && targetXsdType != null && sourceXsdType.equals(targetXsdType) || sourceType instanceof XSDComplexType && this.checkSequence((XSDComplexType)sourceType, targetType) || targetType instanceof XSDComplexType && this.checkSequence((XSDComplexType)targetType, sourceType)) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            return target;
        }
        LogicalAttachPoint parent = (LogicalAttachPoint)source.getParent();
        if (parent != null) {
            String sourceComponent = ((LogicalComponent)parent.getParent()).getUri().toString();
            throw new OperationNotFoundException("Target operation not found for " + sourceDefinition.getName() + " on source component " + sourceComponent);
        }
        throw new OperationNotFoundException("Target operation not found for " + sourceDefinition.getName());
    }

    private boolean checkSequence(XSDComplexType complexType, DataType type) {
        XSDType sequenceType;
        return complexType.isSequence() && complexType.getSequenceTypes().size() == 1 && (sequenceType = (XSDType)complexType.getSequenceTypes().get(0)).getXsdType().equals(type.getXsdType());
    }
}

