/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.wire;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.wire.CallbackBindingGenerator;
import org.fabric3.spi.domain.generator.wire.WireGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalWireDefinition;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

public class BoundServiceCommandGenerator
implements CommandGenerator {
    private WireGenerator wireGenerator;
    private Map<Class<?>, CallbackBindingGenerator> generators = Collections.emptyMap();

    public BoundServiceCommandGenerator(@Reference WireGenerator wireGenerator) {
        this.wireGenerator = wireGenerator;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Reference(required=false)
    public void setCallbackBindingGenerators(Map<Class<?>, CallbackBindingGenerator> generators) {
        this.generators = generators;
    }

    @Override
    public ConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        boolean bindingChange = false;
        block0: for (LogicalService service : component.getServices()) {
            for (LogicalBinding binding : service.getBindings()) {
                if (binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED) continue;
                bindingChange = true;
                continue block0;
            }
        }
        if (LogicalState.PROVISIONED == component.getState() && incremental && !bindingChange) {
            return null;
        }
        ConnectionCommand command = new ConnectionCommand(component.getUri());
        this.generatePhysicalWires(component, command, incremental);
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generatePhysicalWires(LogicalComponent<?> component, ConnectionCommand command, boolean incremental) throws GenerationException {
        for (LogicalService service : component.getServices()) {
            if (service.getBindings().isEmpty()) continue;
            ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
            LogicalBinding callbackBinding = null;
            URI callbackUri = null;
            if (callbackContract != null) {
                List callbackBindings = service.getCallbackBindings();
                if (callbackBindings.isEmpty()) {
                    this.generateCallbackBindings(service);
                }
                if (callbackBindings.size() != 1) {
                    String uri = service.getUri().toString();
                    throw new UnsupportedOperationException("The runtime requires exactly one callback binding to be specified on service: " + uri);
                }
                callbackBinding = (LogicalBinding)callbackBindings.get(0);
                callbackUri = callbackBinding.getDefinition().getTargetUri();
            }
            for (LogicalBinding binding : service.getBindings()) {
                if (binding.getDefinition() instanceof SCABinding || binding.getState() != LogicalState.NEW && binding.getState() != LogicalState.MARKED && incremental) continue;
                PhysicalWireDefinition pwd = this.wireGenerator.generateBoundService(binding, callbackUri);
                if (LogicalState.MARKED == binding.getState()) {
                    DetachWireCommand detachWireCommand = new DetachWireCommand();
                    detachWireCommand.setPhysicalWireDefinition(pwd);
                    command.add(detachWireCommand);
                    continue;
                }
                AttachWireCommand attachWireCommand = new AttachWireCommand();
                attachWireCommand.setPhysicalWireDefinition(pwd);
                command.add(attachWireCommand);
            }
            if (callbackBinding == null || callbackBinding.getDefinition() instanceof SCABinding || callbackBinding.getState() != LogicalState.NEW && callbackBinding.getState() != LogicalState.MARKED && incremental) continue;
            PhysicalWireDefinition callbackPwd = this.wireGenerator.generateBoundServiceCallback(callbackBinding);
            if (LogicalState.MARKED == callbackBinding.getState()) {
                DetachWireCommand detachWireCommand = new DetachWireCommand();
                detachWireCommand.setPhysicalWireDefinition(callbackPwd);
                command.add(detachWireCommand);
                continue;
            }
            AttachWireCommand attachWireCommand = new AttachWireCommand();
            attachWireCommand.setPhysicalWireDefinition(callbackPwd);
            command.add(attachWireCommand);
        }
    }

    private void generateCallbackBindings(LogicalService service) throws GenerationException {
        for (LogicalBinding logicalBinding : service.getBindings()) {
            if (logicalBinding.getDefinition() instanceof SCABinding) continue;
            CallbackBindingGenerator generator = this.generators.get(logicalBinding.getDefinition().getClass());
            if (generator == null) {
                throw new GenerationException("Callback generator not found for:" + logicalBinding.getDefinition().getType());
            }
            BindingDefinition definition = generator.generateServiceCallback(logicalBinding);
            definition.setParent((ModelObject)service.getDefinition());
            LogicalBinding logicalCallback = new LogicalBinding(definition, (Bindable)service);
            service.addCallbackBinding(logicalCallback);
        }
    }
}

