/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.resource;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.component.ResourceDefinition;
import org.fabric3.fabric.container.command.BuildResourcesCommand;
import org.fabric3.fabric.container.command.DisposeResourcesCommand;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.domain.generator.resource.DomainResourceCommandGenerator;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.resource.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalResourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class DomainResourceCommandGeneratorImpl
implements DomainResourceCommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public DomainResourceCommandGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public CompensatableCommand generateBuild(LogicalResource resource, boolean incremental) throws GenerationException {
        if (resource.getState() != LogicalState.NEW && incremental) {
            return null;
        }
        List<PhysicalResourceDefinition> definitions = this.createDefinitions(resource);
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildResourcesCommand(definitions);
    }

    @Override
    public CompensatableCommand generateDispose(LogicalResource resource, boolean incremental) throws GenerationException {
        if (resource.getState() != LogicalState.MARKED) {
            return null;
        }
        List<PhysicalResourceDefinition> definitions = this.createDefinitions(resource);
        if (definitions.isEmpty()) {
            return null;
        }
        return new DisposeResourcesCommand(definitions);
    }

    private List<PhysicalResourceDefinition> createDefinitions(LogicalResource resource) throws GenerationException {
        ArrayList<PhysicalResourceDefinition> definitions = new ArrayList<PhysicalResourceDefinition>();
        ResourceDefinition resourceDefinition = resource.getDefinition();
        ResourceGenerator<?> generator = this.generatorRegistry.getResourceGenerator(resourceDefinition.getClass());
        PhysicalResourceDefinition definition = generator.generateResource(resource);
        definitions.add(definition);
        return definitions;
    }
}

