/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.resource;

import java.util.ArrayList;
import org.fabric3.api.model.type.component.ResourceDefinition;
import org.fabric3.fabric.container.command.DisposeResourcesCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.resource.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalResourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class DisposeResourceCommandGenerator
implements CommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public DisposeResourceCommandGenerator(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public int getOrder() {
        return 6;
    }

    @Override
    public DisposeResourcesCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent) || component.getState() != LogicalState.MARKED) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        if (composite.getResources().isEmpty()) {
            return null;
        }
        ArrayList<PhysicalResourceDefinition> definitions = new ArrayList<PhysicalResourceDefinition>();
        for (LogicalResource resource : composite.getResources()) {
            ResourceDefinition resourceDefinition = resource.getDefinition();
            ResourceGenerator<?> generator = this.generatorRegistry.getResourceGenerator(resourceDefinition.getClass());
            PhysicalResourceDefinition definition = generator.generateResource(resource);
            definitions.add(definition);
        }
        if (definitions.isEmpty()) {
            return null;
        }
        return new DisposeResourcesCommand(definitions);
    }
}

