/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.policy;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.definitions.AbstractPolicyDefinition;
import org.fabric3.api.model.type.definitions.BindingType;
import org.fabric3.api.model.type.definitions.ExternalAttachment;
import org.fabric3.api.model.type.definitions.ImplementationType;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.IntentMap;
import org.fabric3.api.model.type.definitions.IntentQualifier;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.api.model.type.definitions.Qualifier;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.domain.generator.policy.PolicyActivationException;
import org.fabric3.spi.domain.generator.policy.PolicyRegistry;
import org.oasisopen.sca.annotation.Reference;

public class DefaultPolicyRegistry
implements PolicyRegistry {
    private MetaDataStore metaDataStore;
    private Map<Class<? extends AbstractPolicyDefinition>, Map<QName, ? extends AbstractPolicyDefinition>> cache = new ConcurrentHashMap<Class<? extends AbstractPolicyDefinition>, Map<QName, ? extends AbstractPolicyDefinition>>();

    public DefaultPolicyRegistry(@Reference MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
        this.cache.put(Intent.class, new ConcurrentHashMap());
        this.cache.put(PolicySet.class, new ConcurrentHashMap());
        this.cache.put(BindingType.class, new ConcurrentHashMap());
        this.cache.put(ImplementationType.class, new ConcurrentHashMap());
    }

    public <D extends AbstractPolicyDefinition> Collection<D> getAllDefinitions(Class<D> definitionClass) {
        return this.getSubCache(definitionClass).values();
    }

    public Set<PolicySet> getExternalAttachmentPolicies() {
        Map<QName, PolicySet> subCache = this.getSubCache(PolicySet.class);
        HashSet<PolicySet> policySets = new HashSet<PolicySet>();
        for (PolicySet policySet : subCache.values()) {
            if (policySet.getAttachTo() == null) continue;
            policySets.add(policySet);
        }
        return policySets;
    }

    public <D extends AbstractPolicyDefinition> D getDefinition(QName name, Class<D> definitionClass) {
        return (D)((AbstractPolicyDefinition)this.getSubCache(definitionClass).get(name));
    }

    public <D extends AbstractPolicyDefinition> Set<D> getDefinitions(Set<QName> names, Class<D> definitionClass) {
        Map<QName, D> subCache = this.getSubCache(definitionClass);
        if (subCache == null) {
            return Collections.emptySet();
        }
        HashSet<AbstractPolicyDefinition> set = new HashSet<AbstractPolicyDefinition>();
        for (AbstractPolicyDefinition value : subCache.values()) {
            if (!names.contains(value.getName())) continue;
            set.add(value);
        }
        return set;
    }

    public Set<PolicySet> activateDefinitions(URI uri) throws PolicyActivationException {
        Contribution contribution = this.metaDataStore.find(uri);
        HashSet<Intent> intents = new HashSet<Intent>();
        HashSet<PolicySet> policySets = new HashSet<PolicySet>();
        HashSet<PolicySet> attachedPolicySets = new HashSet<PolicySet>();
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement resourceElement : resource.getResourceElements()) {
                Object value = resourceElement.getValue();
                if (value instanceof Intent) {
                    Intent intent = (Intent)value;
                    this.activate(intent);
                    intents.add(intent);
                    continue;
                }
                if (value instanceof PolicySet) {
                    PolicySet policySet = (PolicySet)value;
                    this.activate(policySet);
                    if (policySet.getAttachTo() != null) {
                        attachedPolicySets.add(policySet);
                    }
                    policySets.add(policySet);
                    continue;
                }
                if (value instanceof BindingType) {
                    BindingType bindingType = (BindingType)value;
                    this.activate(bindingType);
                    continue;
                }
                if (value instanceof ImplementationType) {
                    ImplementationType implementationType = (ImplementationType)value;
                    this.activate(implementationType);
                    continue;
                }
                if (!(value instanceof ExternalAttachment)) continue;
                ExternalAttachment externalAttachment = (ExternalAttachment)value;
                this.activate(externalAttachment);
            }
        }
        this.validateIntents(intents);
        this.validatePolicySets(policySets);
        return attachedPolicySets;
    }

    public Set<PolicySet> deactivateDefinitions(URI uri) throws PolicyActivationException {
        HashSet<PolicySet> policySets = new HashSet<PolicySet>();
        Contribution contribution = this.metaDataStore.find(uri);
        for (Resource resource : contribution.getResources()) {
            for (ResourceElement resourceElement : resource.getResourceElements()) {
                PolicySet policySet;
                Object value = resourceElement.getValue();
                if (!(value instanceof AbstractPolicyDefinition)) continue;
                AbstractPolicyDefinition definition = (AbstractPolicyDefinition)value;
                this.deactivate(definition);
                if (!(definition instanceof PolicySet) || (policySet = (PolicySet)definition).getAttachTo() == null) continue;
                policySets.add(policySet);
            }
        }
        return policySets;
    }

    private void deactivate(AbstractPolicyDefinition definition) {
        if (definition instanceof Intent) {
            this.getSubCache(Intent.class).remove(definition.getName());
        } else if (definition instanceof PolicySet) {
            this.getSubCache(PolicySet.class).remove(definition.getName());
        } else if (definition instanceof BindingType) {
            this.getSubCache(BindingType.class).remove(definition.getName());
        } else if (definition instanceof ImplementationType) {
            this.getSubCache(ImplementationType.class).remove(definition.getName());
        } else if (definition instanceof ExternalAttachment) {
            this.getSubCache(ExternalAttachment.class).remove(definition.getName());
        }
    }

    private void activate(Intent intent) throws PolicyActivationException {
        QName name;
        Map<QName, Intent> subCache = this.getSubCache(Intent.class);
        if (subCache.containsKey(name = intent.getName())) {
            throw new PolicyActivationException("Duplicate intent found:" + name);
        }
        subCache.put(name, intent);
    }

    private void activate(PolicySet policySet) throws PolicyActivationException {
        QName name;
        Map<QName, PolicySet> subCache = this.getSubCache(PolicySet.class);
        if (subCache.containsKey(name = policySet.getName())) {
            throw new PolicyActivationException("Duplicate policy set found:" + name);
        }
        subCache.put(name, policySet);
    }

    private void activate(BindingType bindingType) throws PolicyActivationException {
        QName name;
        Map<QName, BindingType> subCache = this.getSubCache(BindingType.class);
        if (subCache.containsKey(name = bindingType.getName())) {
            throw new PolicyActivationException("Duplicate binding type found:" + name);
        }
        subCache.put(name, bindingType);
    }

    private void activate(ImplementationType implementationType) throws PolicyActivationException {
        QName name;
        Map<QName, ImplementationType> subCache = this.getSubCache(ImplementationType.class);
        if (subCache.containsKey(name = implementationType.getName())) {
            throw new PolicyActivationException("Duplicate implementation type found:" + name);
        }
        subCache.put(name, implementationType);
    }

    private void activate(ExternalAttachment externalAttachment) {
        Map<QName, ExternalAttachment> subCache = this.getSubCache(ExternalAttachment.class);
        QName name = externalAttachment.getName();
        subCache.put(name, externalAttachment);
    }

    private void validateIntents(Set<Intent> intents) throws PolicyActivationException {
        Map<QName, Intent> subCache = this.getSubCache(Intent.class);
        for (Intent intent : intents) {
            for (QName required : intent.getRequires()) {
                if (subCache.containsKey(required)) continue;
                throw new PolicyActivationException("Required intent specified in " + intent.getName() + " not found: " + required);
            }
            for (QName excluded : intent.getExcludes()) {
                if (subCache.containsKey(excluded)) continue;
                throw new PolicyActivationException("Excluded intent specified in " + intent.getName() + " not found: " + excluded);
            }
        }
    }

    private void validatePolicySets(Set<PolicySet> policySets) throws PolicyActivationException {
        Map<QName, Intent> intentCache = this.getSubCache(Intent.class);
        for (PolicySet policySet : policySets) {
            QName name;
            for (IntentMap intentMap : policySet.getIntentMaps()) {
                QName provides = intentMap.getProvides();
                Intent intent = intentCache.get(provides);
                if (intent == null) {
                    name = policySet.getName();
                    throw new PolicyActivationException("Intent " + provides + " specified as the provided intent for " + name + " was not found");
                }
                for (Qualifier qualifier : intent.getQualifiers()) {
                    String qualifierName = qualifier.getName();
                    boolean found = false;
                    for (IntentQualifier intentQualifier : intentMap.getQualifiers()) {
                        if (!intentQualifier.getName().equals(qualifierName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    QName name2 = policySet.getName();
                    throw new PolicyActivationException("Intent map that provides " + intentMap.getProvides() + " in policy set " + name2 + " does not specify the qualifier " + qualifierName);
                }
            }
            if (policySet.getPolicySetReferences().isEmpty()) continue;
            Map<QName, PolicySet> policySetCache = this.getSubCache(PolicySet.class);
            for (QName referenceName : policySet.getPolicySetReferences()) {
                PolicySet referencedPolicySet = policySetCache.get(referenceName);
                if (referencedPolicySet == null) {
                    name = policySet.getName();
                    throw new PolicyActivationException("Referenced policy set " + referenceName + " from " + name + " was not found");
                }
                for (QName provided : referencedPolicySet.getProvidedIntents()) {
                    if (policySet.doesProvide(provided)) continue;
                    QName name3 = policySet.getName();
                    throw new PolicyActivationException("Referenced policy set " + referenceName + " from " + name3 + " provides an intent " + provided + " that is not provided by the parent policy set");
                }
            }
        }
    }

    private <D extends AbstractPolicyDefinition> Map<QName, D> getSubCache(Class<D> definitionClass) {
        Map<QName, ? extends AbstractPolicyDefinition> map = this.cache.get(definitionClass);
        if (map == null) {
            map = new HashMap<QName, AbstractPolicyDefinition>();
            this.cache.put(definitionClass, map);
        }
        return map;
    }
}

