/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.ResourceDefinition;
import org.fabric3.api.model.type.component.ResourceReferenceDefinition;
import org.fabric3.fabric.domain.generator.GeneratorNotFoundException;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.domain.generator.channel.ConnectionBindingGenerator;
import org.fabric3.spi.domain.generator.channel.EventStreamHandlerGenerator;
import org.fabric3.spi.domain.generator.component.ComponentGenerator;
import org.fabric3.spi.domain.generator.resource.ResourceGenerator;
import org.fabric3.spi.domain.generator.resource.ResourceReferenceGenerator;
import org.fabric3.spi.domain.generator.wire.InterceptorGenerator;
import org.fabric3.spi.domain.generator.wire.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.oasisopen.sca.annotation.Reference;

public class GeneratorRegistryImpl
implements GeneratorRegistry {
    private Map<Class<?>, ComponentGenerator<?>> componentGenerators = new HashMap();
    private Map<Class<?>, WireBindingGenerator<?>> bindingGenerators = new HashMap();
    private Map<Class<?>, ConnectionBindingGenerator<?>> connectionBindingGenerators = new ConcurrentHashMap();
    private Map<QName, InterceptorGenerator> interceptorGenerators = new HashMap<QName, InterceptorGenerator>();
    private Map<QName, EventStreamHandlerGenerator> handlerGenerators = new HashMap<QName, EventStreamHandlerGenerator>();
    private Map<Class<?>, ResourceReferenceGenerator<?>> resourceReferenceGenerators = new HashMap();
    private Map<Class<?>, ResourceGenerator<?>> resourceGenerators = new HashMap();

    @Reference(required=false)
    public void setComponentGenerators(Map<Class<?>, ComponentGenerator<?>> componentGenerators) {
        this.componentGenerators = componentGenerators;
    }

    @Reference(required=false)
    public void setBindingGenerators(Map<Class<?>, WireBindingGenerator<?>> bindingGenerators) {
        this.bindingGenerators = bindingGenerators;
    }

    @Reference(required=false)
    public void setConnectionBindingGenerators(Map<Class<?>, ConnectionBindingGenerator<?>> bindingGenerators) {
        this.connectionBindingGenerators = bindingGenerators;
    }

    @Reference(required=false)
    public void setResourceReferenceGenerators(Map<Class<?>, ResourceReferenceGenerator<?>> resourceReferenceGenerators) {
        this.resourceReferenceGenerators = resourceReferenceGenerators;
    }

    @Reference(required=false)
    public void setInterceptorGenerators(Map<QName, InterceptorGenerator> interceptorGenerators) {
        this.interceptorGenerators = interceptorGenerators;
    }

    @Reference(required=false)
    public void setResourceGenerators(Map<Class<?>, ResourceGenerator<?>> resourceGenerators) {
        this.resourceGenerators = resourceGenerators;
    }

    @Reference(required=false)
    public void setHandlerGenerators(Map<QName, EventStreamHandlerGenerator> handlerGenerators) {
        this.handlerGenerators = handlerGenerators;
    }

    public <T extends Implementation<?>> void register(Class<T> clazz, ComponentGenerator<LogicalComponent<T>> generator) {
        this.componentGenerators.put(clazz, generator);
    }

    public <T extends ResourceReferenceDefinition> void register(Class<T> clazz, ResourceReferenceGenerator<T> generator) {
        this.resourceReferenceGenerators.put(clazz, generator);
    }

    public <T extends BindingDefinition> void register(Class<T> clazz, WireBindingGenerator<T> generator) {
        this.bindingGenerators.put(clazz, generator);
    }

    @Override
    public <T extends Implementation<?>> ComponentGenerator<LogicalComponent<T>> getComponentGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ComponentGenerator<?> generator = this.componentGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public <T extends BindingDefinition> WireBindingGenerator<T> getBindingGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        WireBindingGenerator<?> generator = this.bindingGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    public <T extends BindingDefinition> ConnectionBindingGenerator<T> getConnectionBindingGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ConnectionBindingGenerator<?> generator = this.connectionBindingGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public <T extends ResourceReferenceDefinition> ResourceReferenceGenerator<T> getResourceReferenceGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ResourceReferenceGenerator<?> generator = this.resourceReferenceGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }

    @Override
    public InterceptorGenerator getInterceptorGenerator(QName extensionName) throws GeneratorNotFoundException {
        InterceptorGenerator generator = this.interceptorGenerators.get(extensionName);
        if (generator == null) {
            throw new GeneratorNotFoundException(extensionName);
        }
        return generator;
    }

    @Override
    public EventStreamHandlerGenerator getEventStreamHandlerGenerator(QName extensionName) throws GeneratorNotFoundException {
        EventStreamHandlerGenerator generator = this.handlerGenerators.get(extensionName);
        if (generator == null) {
            throw new GeneratorNotFoundException(extensionName);
        }
        return generator;
    }

    @Override
    public <T extends ResourceDefinition> ResourceGenerator<T> getResourceGenerator(Class<T> clazz) throws GeneratorNotFoundException {
        ResourceGenerator<?> generator = this.resourceGenerators.get(clazz);
        if (generator == null) {
            throw new GeneratorNotFoundException(clazz);
        }
        return generator;
    }
}

