/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.GenerationType;
import org.fabric3.fabric.domain.generator.classloader.ClassLoaderCommandGenerator;
import org.fabric3.fabric.domain.generator.collator.ContributionCollator;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGenerator;
import org.fabric3.fabric.domain.generator.context.StopContextCommandGenerator;
import org.fabric3.fabric.domain.generator.extension.ExtensionGenerator;
import org.fabric3.fabric.domain.generator.resource.DomainResourceCommandGenerator;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.domain.generator.Deployment;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.Generator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.type.remote.RemoteImplementation;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class GeneratorImpl
implements Generator {
    private static final Comparator<LogicalComponent<?>> COMPARATOR = new Comparator<LogicalComponent<?>>(){

        @Override
        public int compare(LogicalComponent<?> first, LogicalComponent<?> second) {
            return first.getUri().compareTo(second.getUri());
        }
    };
    private List<CommandGenerator> commandGenerators;
    private ContributionCollator collator;
    private ClassLoaderCommandGenerator classLoaderCommandGenerator;
    private StartContextCommandGenerator startContextCommandGenerator;
    private StopContextCommandGenerator stopContextCommandGenerator;
    private ExtensionGenerator extensionGenerator;
    private DomainResourceCommandGenerator resourceGenerator;

    @Constructor
    public GeneratorImpl(@Reference List<CommandGenerator> commandGenerators, @Reference ContributionCollator collator, @Reference ClassLoaderCommandGenerator classLoaderCommandGenerator, @Reference StartContextCommandGenerator startContextCommandGenerator, @Reference StopContextCommandGenerator stopContextCommandGenerator) {
        this.collator = collator;
        this.classLoaderCommandGenerator = classLoaderCommandGenerator;
        this.startContextCommandGenerator = startContextCommandGenerator;
        this.stopContextCommandGenerator = stopContextCommandGenerator;
        this.commandGenerators = this.sortGenerators(commandGenerators);
    }

    @Reference(required=false)
    public void setExtensionGenerator(ExtensionGenerator extensionGenerator) {
        this.extensionGenerator = extensionGenerator;
    }

    @Reference
    public void setResourceGenerator(DomainResourceCommandGenerator generator) {
        this.resourceGenerator = generator;
    }

    public Deployment generate(LogicalCompositeComponent domain, boolean incremental) throws GenerationException {
        CompensatableCommand command;
        String zone;
        List<LogicalComponent<?>> sorted = this.topologicalSort(domain);
        String id = UUID.randomUUID().toString();
        Deployment deployment = new Deployment(id);
        Map<String, List<Contribution>> deployingContributions = this.generateClassLoaders(deployment, sorted, incremental);
        Map<String, List<CompensatableCommand>> stopCommands = this.stopContextCommandGenerator.generate(sorted);
        for (Map.Entry<String, List<CompensatableCommand>> entry : stopCommands.entrySet()) {
            deployment.addCommands(entry.getKey(), entry.getValue());
        }
        if (this.resourceGenerator != null) {
            for (LogicalResource resource : domain.getResources()) {
                zone = resource.getZone();
                command = this.resourceGenerator.generateBuild(resource, incremental);
                if (command == null) continue;
                deployment.addCommand(zone, command);
            }
        }
        for (CommandGenerator generator : this.commandGenerators) {
            for (LogicalComponent<?> component : sorted) {
                String zone2;
                CompensatableCommand command2;
                if (component.getDefinition().getImplementation() instanceof RemoteImplementation || (command2 = generator.generate(component, incremental)) == null || deployment.getDeploymentUnit(zone2 = component.getZone()).getCommands().contains(command2)) continue;
                deployment.addCommand(zone2, command2);
            }
        }
        if (this.resourceGenerator != null) {
            for (LogicalResource resource : domain.getResources()) {
                zone = resource.getZone();
                command = this.resourceGenerator.generateDispose(resource, incremental);
                if (command == null) continue;
                deployment.addCommand(zone, command);
            }
        }
        Map<String, List<CompensatableCommand>> startCommands = this.startContextCommandGenerator.generate(sorted, incremental);
        for (Map.Entry<String, List<CompensatableCommand>> entry : startCommands.entrySet()) {
            deployment.addCommands(entry.getKey(), entry.getValue());
        }
        this.generateReleaseClassLoaders(deployment, sorted, deployingContributions, incremental);
        return deployment;
    }

    private Map<String, List<Contribution>> generateClassLoaders(Deployment deployment, List<LogicalComponent<?>> components, boolean incremental) throws GenerationException {
        Map<String, List<Contribution>> deployingContributions = incremental ? this.collator.collateContributions(components, GenerationType.INCREMENTAL) : this.collator.collateContributions(components, GenerationType.FULL);
        Map<String, List<CompensatableCommand>> commandsPerZone = this.classLoaderCommandGenerator.generate(deployingContributions);
        for (Map.Entry<String, List<CompensatableCommand>> entry : commandsPerZone.entrySet()) {
            deployment.addProvisionCommands(entry.getKey(), entry.getValue());
        }
        return deployingContributions;
    }

    private void generateReleaseClassLoaders(Deployment deployment, List<LogicalComponent<?>> components, Map<String, List<Contribution>> contributions, boolean incremental) throws GenerationException {
        Map<String, List<Contribution>> undeployingContributions = this.collator.collateContributions(components, GenerationType.UNDEPLOY);
        Map<String, List<CompensatableCommand>> releaseCommandsPerZone = this.classLoaderCommandGenerator.release(undeployingContributions);
        for (Map.Entry<String, List<CompensatableCommand>> entry : releaseCommandsPerZone.entrySet()) {
            deployment.addCommands(entry.getKey(), entry.getValue());
        }
        if (incremental) {
            this.generateExtensionCommands(deployment, contributions, components, GenerationType.INCREMENTAL);
        } else {
            this.generateExtensionCommands(deployment, contributions, components, GenerationType.FULL);
        }
        this.generateExtensionCommands(deployment, undeployingContributions, components, GenerationType.UNDEPLOY);
    }

    private void generateExtensionCommands(Deployment deployment, Map<String, List<Contribution>> deployingContributions, List<LogicalComponent<?>> components, GenerationType type) throws GenerationException {
        Map deploymentCmds;
        Map<String, CompensatableCommand> zoneExtensions;
        if (this.extensionGenerator != null && (zoneExtensions = this.extensionGenerator.generate(deployingContributions, components, deploymentCmds = deployment.getCommands(), type)) != null) {
            for (Map.Entry<String, CompensatableCommand> entry : zoneExtensions.entrySet()) {
                if (type == GenerationType.UNDEPLOY) {
                    deployment.addCommand(entry.getKey(), entry.getValue());
                    continue;
                }
                deployment.addExtensionCommand(entry.getKey(), entry.getValue());
            }
        }
    }

    private List<LogicalComponent<?>> topologicalSort(LogicalCompositeComponent domain) {
        ArrayList sorted = new ArrayList();
        for (LogicalComponent component : domain.getComponents()) {
            sorted.add(component);
            if (!(component instanceof LogicalCompositeComponent)) continue;
            this.flatten((LogicalCompositeComponent)component, sorted);
        }
        Collections.sort(sorted, COMPARATOR);
        return sorted;
    }

    private void flatten(LogicalCompositeComponent component, List<LogicalComponent<?>> components) {
        for (LogicalComponent child : component.getComponents()) {
            components.add(child);
            if (!(child instanceof LogicalCompositeComponent)) continue;
            this.flatten((LogicalCompositeComponent)child, components);
        }
    }

    private List<CommandGenerator> sortGenerators(List<? extends CommandGenerator> commandGenerators) {
        Comparator<CommandGenerator> generatorComparator = new Comparator<CommandGenerator>(){

            @Override
            public int compare(CommandGenerator first, CommandGenerator second) {
                return first.getOrder() - second.getOrder();
            }
        };
        ArrayList<CommandGenerator> sorted = new ArrayList<CommandGenerator>(commandGenerators);
        Collections.sort(sorted, generatorComparator);
        return sorted;
    }
}

