/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.fabric.domain.generator.context.StartContextCommandGenerator;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class StartContextCommandGeneratorImpl
implements StartContextCommandGenerator {
    @Override
    public Map<String, List<CompensatableCommand>> generate(List<LogicalComponent<?>> components, boolean incremental) throws GenerationException {
        HashMap<String, List<CompensatableCommand>> commands = new HashMap<String, List<CompensatableCommand>>();
        for (LogicalComponent<?> component : components) {
            if (component.getState() != LogicalState.NEW && incremental) continue;
            QName deployable = component.getDeployable();
            boolean log = !component.getUri().toString().startsWith("fabric3://runtime");
            StartContextCommand command = new StartContextCommand(deployable, log);
            String zone = component.getZone();
            List<CompensatableCommand> list = this.getCommands(zone, commands);
            if (list.contains(command)) continue;
            list.add(command);
        }
        return commands;
    }

    private List<CompensatableCommand> getCommands(String zone, Map<String, List<CompensatableCommand>> startCommands) {
        List<CompensatableCommand> list = startCommands.get(zone);
        if (list == null) {
            list = new ArrayList<CompensatableCommand>();
            startCommands.put(zone, list);
        }
        return list;
    }
}

