/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.collator;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Names;
import org.fabric3.fabric.domain.generator.GenerationType;
import org.fabric3.fabric.domain.generator.collator.ContributionCollator;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.oasisopen.sca.annotation.Reference;

public class ContributionCollatorImpl
implements ContributionCollator {
    private MetaDataStore store;

    public ContributionCollatorImpl(@Reference MetaDataStore store) {
        this.store = store;
    }

    @Override
    public Map<String, List<Contribution>> collateContributions(List<LogicalComponent<?>> components, GenerationType type) {
        HashMap<String, List<Contribution>> contributionsPerZone = new HashMap<String, List<Contribution>>();
        for (LogicalComponent<?> component : components) {
            Contribution contribution;
            if (type != GenerationType.FULL && (GenerationType.INCREMENTAL == type && LogicalState.NEW != component.getState() || GenerationType.UNDEPLOY == type && LogicalState.MARKED != component.getState())) continue;
            URI contributionUri = component.getDefinition().getContributionUri();
            String zone = component.getZone();
            ArrayList<Contribution> contributions = (ArrayList<Contribution>)contributionsPerZone.get(zone);
            if (contributions == null) {
                contributions = new ArrayList<Contribution>();
                contributionsPerZone.put(zone, contributions);
            }
            if (!this.include(contribution = this.store.find(contributionUri), contributions)) continue;
            this.collateDependencies(contribution, contributions);
        }
        return contributionsPerZone;
    }

    private void collateDependencies(Contribution contribution, List<Contribution> contributions) {
        List contributionWires = contribution.getWires();
        for (ContributionWire wire : contributionWires) {
            URI importedUri = wire.getExportContributionUri();
            Contribution imported = this.store.find(importedUri);
            if (!this.include(imported, contributions)) continue;
            this.collateDependencies(imported, contributions);
        }
        if (!contributions.contains(contribution)) {
            contributions.add(contribution);
        }
    }

    private boolean include(Contribution contribution, List<Contribution> contributions) {
        URI uri = contribution.getUri();
        return !contributions.contains(contribution) && !Names.HOST_CONTRIBUTION.equals(uri) && !Names.BOOT_CONTRIBUTION.equals(uri);
    }
}

