/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.classloader;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.Names;
import org.fabric3.fabric.container.command.AttachExtensionCommand;
import org.fabric3.fabric.container.command.ProvisionClassloaderCommand;
import org.fabric3.fabric.container.command.UnprovisionClassloaderCommand;
import org.fabric3.fabric.domain.generator.classloader.ClassLoaderCommandGenerator;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.contribution.ClassLoaderWireGenerator;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.DependencyException;
import org.fabric3.spi.contribution.DependencyResolver;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.model.physical.PhysicalClassLoaderDefinition;
import org.fabric3.spi.model.physical.PhysicalClassLoaderWireDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ClassLoaderCommandGeneratorImpl
implements ClassLoaderCommandGenerator {
    private Map<Class<? extends ContributionWire<?, ?>>, ClassLoaderWireGenerator<?>> generators;
    private DependencyResolver dependencyResolver;

    public ClassLoaderCommandGeneratorImpl(@Reference Map<Class<? extends ContributionWire<?, ?>>, ClassLoaderWireGenerator<?>> generators) {
        this.generators = generators;
    }

    @Reference(required=false)
    public void setDependencyService(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public Map<String, List<CompensatableCommand>> generate(Map<String, List<Contribution>> contributions) throws GenerationException {
        Map<String, List<PhysicalClassLoaderDefinition>> definitionsPerZone = this.createContributionDefinitions(contributions);
        Map<String, List<CompensatableCommand>> commands = this.createProvisionCommands(definitionsPerZone);
        this.createExtensionCommands(commands, contributions);
        return commands;
    }

    @Override
    public Map<String, List<CompensatableCommand>> release(Map<String, List<Contribution>> contributions) throws GenerationException {
        HashMap<String, List<CompensatableCommand>> commandsPerZone = new HashMap<String, List<CompensatableCommand>>();
        for (Map.Entry<String, List<Contribution>> entry : contributions.entrySet()) {
            List ordered;
            if (entry.getKey() == null) continue;
            ArrayList<UnprovisionClassloaderCommand> commands = (ArrayList<UnprovisionClassloaderCommand>)commandsPerZone.get(entry.getKey());
            if (commands == null) {
                commands = new ArrayList<UnprovisionClassloaderCommand>();
                commandsPerZone.put(entry.getKey(), commands);
            }
            try {
                ordered = this.dependencyResolver.resolve(new ArrayList(entry.getValue()));
                Collections.reverse(ordered);
            }
            catch (DependencyException e) {
                throw new GenerationException((Throwable)e);
            }
            for (Contribution contribution : ordered) {
                PhysicalClassLoaderDefinition definition = this.createClassLoaderDefinition(contribution);
                UnprovisionClassloaderCommand command = new UnprovisionClassloaderCommand(definition);
                commands.add(command);
            }
        }
        return commandsPerZone;
    }

    private Map<String, List<PhysicalClassLoaderDefinition>> createContributionDefinitions(Map<String, List<Contribution>> contributionsPerZone) {
        HashMap<String, List<PhysicalClassLoaderDefinition>> definitionsPerZone = new HashMap<String, List<PhysicalClassLoaderDefinition>>();
        for (Map.Entry<String, List<Contribution>> entry : contributionsPerZone.entrySet()) {
            String zone = entry.getKey();
            for (Contribution contribution : entry.getValue()) {
                PhysicalClassLoaderDefinition definition = this.createClassLoaderDefinition(contribution);
                if (definition == null) continue;
                ArrayList<PhysicalClassLoaderDefinition> definitions = (ArrayList<PhysicalClassLoaderDefinition>)definitionsPerZone.get(zone);
                if (definitions == null) {
                    definitions = new ArrayList<PhysicalClassLoaderDefinition>();
                    definitionsPerZone.put(zone, definitions);
                }
                definitions.add(definition);
            }
        }
        return definitionsPerZone;
    }

    private PhysicalClassLoaderDefinition createClassLoaderDefinition(Contribution contribution) {
        URI uri = contribution.getUri();
        if (Names.BOOT_CONTRIBUTION.equals(uri) || Names.HOST_CONTRIBUTION.equals(uri)) {
            return null;
        }
        boolean provisionArtifact = contribution.getLocation() != null;
        List libraries = contribution.getManifest().getLibraries();
        PhysicalClassLoaderDefinition definition = new PhysicalClassLoaderDefinition(uri, libraries, provisionArtifact);
        List contributionWires = contribution.getWires();
        for (ContributionWire wire : contributionWires) {
            ClassLoaderWireGenerator<?> generator = this.generators.get(wire.getClass());
            if (generator == null) continue;
            PhysicalClassLoaderWireDefinition wireDefinition = generator.generate(wire);
            definition.add(wireDefinition);
        }
        return definition;
    }

    private Map<String, List<CompensatableCommand>> createProvisionCommands(Map<String, List<PhysicalClassLoaderDefinition>> definitionsPerZone) {
        HashMap<String, List<CompensatableCommand>> commandsPerZone = new HashMap<String, List<CompensatableCommand>>();
        for (Map.Entry<String, List<PhysicalClassLoaderDefinition>> entry : definitionsPerZone.entrySet()) {
            List<PhysicalClassLoaderDefinition> definitions = entry.getValue();
            ArrayList<ProvisionClassloaderCommand> commands = new ArrayList<ProvisionClassloaderCommand>();
            commandsPerZone.put(entry.getKey(), commands);
            for (PhysicalClassLoaderDefinition definition : definitions) {
                commands.add(new ProvisionClassloaderCommand(definition));
            }
        }
        return commandsPerZone;
    }

    private void createExtensionCommands(Map<String, List<CompensatableCommand>> commands, Map<String, List<Contribution>> collated) {
        for (Map.Entry<String, List<Contribution>> entry : collated.entrySet()) {
            String zone = entry.getKey();
            for (Contribution contribution : entry.getValue()) {
                URI contributionUri = contribution.getUri();
                for (URI providerUri : contribution.getResolvedExtensionProviders()) {
                    AttachExtensionCommand command = new AttachExtensionCommand(contributionUri, providerUri);
                    commands.get(zone).add(command);
                }
            }
        }
    }
}

