/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.container.command.AttachChannelConnectionCommand;
import org.fabric3.fabric.container.command.BuildChannelCommand;
import org.fabric3.fabric.container.command.ChannelConnectionCommand;
import org.fabric3.fabric.container.command.DetachChannelConnectionCommand;
import org.fabric3.fabric.container.command.DisposeChannelCommand;
import org.fabric3.fabric.domain.generator.CommandGenerator;
import org.fabric3.fabric.domain.generator.channel.ChannelCommandGenerator;
import org.fabric3.fabric.domain.generator.channel.InvocableGeneratorHelper;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ChannelDirection;
import org.fabric3.spi.domain.generator.channel.ConnectionGenerator;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.oasisopen.sca.annotation.Reference;

public class ProducerCommandGenerator
implements CommandGenerator {
    private ConnectionGenerator connectionGenerator;
    private ChannelCommandGenerator channelGenerator;

    public ProducerCommandGenerator(@Reference ConnectionGenerator connectionGenerator, @Reference ChannelCommandGenerator channelGenerator) {
        this.connectionGenerator = connectionGenerator;
        this.channelGenerator = channelGenerator;
    }

    @Override
    public int getOrder() {
        return 3;
    }

    @Override
    public ChannelConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        ChannelConnectionCommand command = new ChannelConnectionCommand();
        for (LogicalProducer producer : component.getProducers()) {
            this.generateCommand(producer, command, incremental);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generateCommand(LogicalProducer producer, ChannelConnectionCommand command, boolean incremental) throws GenerationException {
        block5: {
            QName deployable;
            LogicalComponent component;
            block4: {
                component = (LogicalComponent)producer.getParent();
                deployable = ((LogicalComponent)producer.getParent()).getDeployable();
                if (LogicalState.MARKED != component.getState()) break block4;
                HashMap<LogicalChannel, ChannelDeliveryType> channels = new HashMap<LogicalChannel, ChannelDeliveryType>();
                for (URI uri : producer.getTargets()) {
                    LogicalChannel channel = InvocableGeneratorHelper.getChannelInHierarchy(uri, (LogicalInvocable)producer);
                    DisposeChannelCommand disposeCommand = this.channelGenerator.generateDispose(channel, deployable, ChannelDirection.PRODUCER);
                    command.addDisposeChannelCommand(disposeCommand);
                    channels.put(channel, disposeCommand.getDefinition().getDeliveryType());
                }
                List definitions = this.connectionGenerator.generateProducer(producer, channels);
                for (PhysicalChannelConnectionDefinition definition : definitions) {
                    DetachChannelConnectionCommand connectionCommand = new DetachChannelConnectionCommand(definition);
                    command.add(connectionCommand);
                }
                break block5;
            }
            if (LogicalState.NEW != component.getState() && incremental) break block5;
            HashMap<LogicalChannel, ChannelDeliveryType> channels = new HashMap<LogicalChannel, ChannelDeliveryType>();
            for (URI uri : producer.getTargets()) {
                LogicalChannel channel = InvocableGeneratorHelper.getChannelInHierarchy(uri, (LogicalInvocable)producer);
                BuildChannelCommand buildCommand = this.channelGenerator.generateBuild(channel, deployable, ChannelDirection.PRODUCER);
                command.addBuildChannelCommand(buildCommand);
                channels.put(channel, buildCommand.getDefinition().getDeliveryType());
            }
            List definitions = this.connectionGenerator.generateProducer(producer, channels);
            for (PhysicalChannelConnectionDefinition definition : definitions) {
                AttachChannelConnectionCommand connectionCommand = new AttachChannelConnectionCommand(definition);
                command.add(connectionCommand);
            }
        }
    }
}

