/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.ChannelEvent;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.fabric.domain.generator.GeneratorNotFoundException;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.fabric.model.physical.ChannelSourceDefinition;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.fabric.model.physical.TypeEventFilterDefinition;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ConnectionBindingGenerator;
import org.fabric3.spi.domain.generator.channel.ConnectionGenerator;
import org.fabric3.spi.domain.generator.channel.EventStreamHandlerGenerator;
import org.fabric3.spi.domain.generator.component.ComponentGenerator;
import org.fabric3.spi.domain.generator.policy.PolicyMetadata;
import org.fabric3.spi.domain.generator.policy.PolicyResolver;
import org.fabric3.spi.domain.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.model.physical.PhysicalHandlerDefinition;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.Reference;

public class ConnectionGeneratorImpl
implements ConnectionGenerator {
    private GeneratorRegistry generatorRegistry;
    private PolicyResolver resolver;

    public ConnectionGeneratorImpl(@Reference GeneratorRegistry generatorRegistry, @Reference PolicyResolver resolver) {
        this.generatorRegistry = generatorRegistry;
        this.resolver = resolver;
    }

    public List<PhysicalChannelConnectionDefinition> generateProducer(LogicalProducer producer, Map<LogicalChannel, ChannelDeliveryType> channels) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)producer.getParent();
        ComponentGenerator<LogicalComponent> componentGenerator = this.getGenerator(component);
        PhysicalConnectionSourceDefinition sourceDefinition = componentGenerator.generateConnectionSource(producer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        sourceDefinition.setClassLoaderId(classLoaderId);
        PhysicalEventStreamDefinition eventStream = this.generateEventStream(producer);
        for (Map.Entry<LogicalChannel, ChannelDeliveryType> entry : channels.entrySet()) {
            LogicalChannel channel = entry.getKey();
            if (!channel.isBound()) {
                PhysicalChannelConnectionDefinition definition = this.generateProducerConnection(producer, channel, sourceDefinition, classLoaderId, eventStream);
                definitions.add(definition);
                continue;
            }
            PhysicalChannelConnectionDefinition producerDefinition = this.generateProducerConnection(producer, channel, sourceDefinition, classLoaderId, eventStream);
            definitions.add(producerDefinition);
            ChannelDeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnectionDefinition bindingDefinition = this.generateProducerBinding(producer, channel, deliveryType, classLoaderId, eventStream);
            definitions.add(bindingDefinition);
        }
        return definitions;
    }

    public List<PhysicalChannelConnectionDefinition> generateConsumer(LogicalConsumer consumer, Map<LogicalChannel, ChannelDeliveryType> channels) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        ComponentGenerator<LogicalComponent> generator = this.getGenerator(component);
        PhysicalConnectionTargetDefinition targetDefinition = generator.generateConnectionTarget(consumer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        targetDefinition.setClassLoaderId(classLoaderId);
        PhysicalEventStreamDefinition eventStream = this.generateEventStream(consumer);
        this.generatePolicy(consumer, eventStream);
        for (Map.Entry<LogicalChannel, ChannelDeliveryType> entry : channels.entrySet()) {
            LogicalChannel channel = entry.getKey();
            if (!channel.isBound()) {
                PhysicalChannelConnectionDefinition definition = this.generateConsumerConnection(consumer, channel, targetDefinition, classLoaderId, eventStream);
                definitions.add(definition);
                continue;
            }
            PhysicalChannelConnectionDefinition consumerConnection = this.generateConsumerConnection(consumer, channel, targetDefinition, classLoaderId, eventStream);
            definitions.add(consumerConnection);
            ChannelDeliveryType deliveryType = entry.getValue();
            PhysicalChannelConnectionDefinition bindingDefinition = this.generateConsumerBinding(consumer, channel, deliveryType, classLoaderId, eventStream);
            definitions.add(bindingDefinition);
        }
        return definitions;
    }

    private PhysicalChannelConnectionDefinition generateConsumerConnection(LogicalConsumer consumer, LogicalChannel channel, PhysicalConnectionTargetDefinition targetDefinition, URI classLoaderId, PhysicalEventStreamDefinition eventStream) throws GenerationException {
        if (!channel.getZone().equals(((LogicalComponent)consumer.getParent()).getZone()) && !channel.isBound()) {
            String name = channel.getDefinition().getName();
            throw new GenerationException("Binding not configured on a channel where the consumer is in a different zone: " + name);
        }
        ChannelSourceDefinition sourceDefinition = new ChannelSourceDefinition(channel.getUri(), ChannelSide.CONSUMER);
        sourceDefinition.setSequence(consumer.getDefinition().getSequence());
        sourceDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition((PhysicalConnectionSourceDefinition)sourceDefinition, targetDefinition, eventStream);
    }

    private PhysicalChannelConnectionDefinition generateConsumerBinding(LogicalConsumer consumer, LogicalChannel channel, ChannelDeliveryType deliveryType, URI classLoaderId, PhysicalEventStreamDefinition eventStream) throws GenerationException {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionSourceDefinition sourceDefinition = bindingGenerator.generateConnectionSource(consumer, binding, deliveryType);
        sourceDefinition.setSequence(consumer.getDefinition().getSequence());
        sourceDefinition.setClassLoaderId(classLoaderId);
        ChannelTargetDefinition targetDefinition = new ChannelTargetDefinition(channel.getUri(), ChannelSide.CONSUMER);
        targetDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition(sourceDefinition, (PhysicalConnectionTargetDefinition)targetDefinition, eventStream);
    }

    private PhysicalChannelConnectionDefinition generateProducerConnection(LogicalProducer producer, LogicalChannel channel, PhysicalConnectionSourceDefinition sourceDefinition, URI classLoaderId, PhysicalEventStreamDefinition eventStream) throws GenerationException {
        if (!channel.getZone().equals(((LogicalComponent)producer.getParent()).getZone()) && !channel.isBound()) {
            String name = channel.getDefinition().getName();
            throw new GenerationException("Binding not configured on a channel where the producer is in a different zone: " + name);
        }
        ChannelTargetDefinition targetDefinition = new ChannelTargetDefinition(channel.getUri(), ChannelSide.PRODUCER);
        targetDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition(sourceDefinition, (PhysicalConnectionTargetDefinition)targetDefinition, eventStream);
    }

    private PhysicalChannelConnectionDefinition generateProducerBinding(LogicalProducer producer, LogicalChannel channel, ChannelDeliveryType deliveryType, URI classLoaderId, PhysicalEventStreamDefinition eventStream) throws GenerationException {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionTargetDefinition targetDefinition = bindingGenerator.generateConnectionTarget(producer, binding, deliveryType);
        targetDefinition.setClassLoaderId(classLoaderId);
        ChannelSourceDefinition sourceDefinition = new ChannelSourceDefinition(channel.getUri(), ChannelSide.PRODUCER);
        sourceDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition((PhysicalConnectionSourceDefinition)sourceDefinition, targetDefinition, eventStream);
    }

    private void generatePolicy(LogicalConsumer consumer, PhysicalEventStreamDefinition eventStream) throws GenerationException {
        PolicyResult result = this.resolver.resolvePolicies(consumer);
        if (result.getInterceptedPolicySets().isEmpty()) {
            return;
        }
        List policies = (List)result.getInterceptedPolicySets().values().iterator().next();
        PolicyMetadata metadata = (PolicyMetadata)result.getMetadata().values().iterator().next();
        for (PolicySet set : policies) {
            QName expressionName = set.getExpressionName();
            EventStreamHandlerGenerator handlerGenerator = this.generatorRegistry.getEventStreamHandlerGenerator(expressionName);
            PhysicalHandlerDefinition definition = handlerGenerator.generate(set.getExpression(), metadata);
            if (definition == null) continue;
            definition.setPolicyClassLoaderId(set.getContributionUri());
            eventStream.addHandlerDefinition(definition);
        }
    }

    private PhysicalEventStreamDefinition generateEventStream(LogicalProducer producer) throws GenerationException {
        Operation operation = producer.getStreamOperation().getDefinition();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition(operation.getName());
        definition.setName(operation.getName());
        List params = operation.getInputTypes();
        if (params.size() < 1) {
            String interfaceName = producer.getServiceContract().getQualifiedInterfaceName();
            throw new GenerationException("A channel interface must have one parameter: operation " + operation.getName() + " on " + interfaceName);
        }
        for (DataType param : params) {
            Class paramType = param.getType();
            String paramName = paramType.getName();
            definition.addEventType(paramName);
        }
        return definition;
    }

    private PhysicalEventStreamDefinition generateEventStream(LogicalConsumer consumer) {
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition("default");
        List types = consumer.getDefinition().getTypes();
        boolean typed = false;
        boolean takesChannelEvent = false;
        for (DataType dataType : types) {
            if (dataType instanceof JavaType && !Object.class.equals((Object)dataType.getType())) {
                typed = true;
                if (ChannelEvent.class.isAssignableFrom(dataType.getType())) {
                    takesChannelEvent = true;
                }
            }
            definition.setChannelEvent(takesChannelEvent);
            definition.addEventType(dataType.getType().getName());
        }
        if (typed) {
            TypeEventFilterDefinition typeFilter = new TypeEventFilterDefinition(types);
            definition.addFilterDefinition((PhysicalEventFilterDefinition)typeFilter);
        }
        return definition;
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) throws GeneratorNotFoundException {
        Implementation implementation = component.getDefinition().getImplementation();
        return this.generatorRegistry.getComponentGenerator(implementation.getClass());
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

