/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.channel;

import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.fabric.domain.generator.GeneratorNotFoundException;
import org.fabric3.fabric.domain.generator.GeneratorRegistry;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ChannelDirection;
import org.fabric3.spi.domain.generator.channel.ChannelGenerator;
import org.fabric3.spi.domain.generator.channel.ChannelGeneratorExtension;
import org.fabric3.spi.domain.generator.channel.ConnectionBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.ChannelSide;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

public class ChannelGeneratorImpl
implements ChannelGenerator {
    private Map<String, ChannelGeneratorExtension> extensions;
    private GeneratorRegistry generatorRegistry;

    @Reference
    public void setExtensions(Map<String, ChannelGeneratorExtension> extensions) {
        this.extensions = extensions;
    }

    public ChannelGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    public PhysicalChannelDefinition generateChannelDefinition(LogicalChannel channel, QName deployable, ChannelDirection direction) throws GenerationException {
        LogicalBinding binding = channel.getBinding();
        String type = channel.getDefinition().getType();
        ChannelGeneratorExtension generator = this.extensions.get(type);
        if (generator == null) {
            throw new GenerationException("Channel generator not found: " + type);
        }
        PhysicalChannelDefinition definition = generator.generate(channel, deployable);
        if (!channel.getBindings().isEmpty()) {
            if (!(binding.getDefinition() instanceof SCABinding)) {
                ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
                ChannelDeliveryType deliveryType = definition.getDeliveryType();
                PhysicalChannelBindingDefinition bindingDefinition = bindingGenerator.generateChannelBinding(binding, deliveryType);
                definition.setBindingDefinition(bindingDefinition);
                definition.setChannelSide(ChannelDirection.CONSUMER == direction ? ChannelSide.CONSUMER : ChannelSide.PRODUCER);
            } else {
                definition.setChannelSide(ChannelSide.COLLOCATED);
            }
        } else {
            definition.setChannelSide(ChannelSide.COLLOCATED);
        }
        return definition;
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

