/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.binding;

import java.util.List;
import org.fabric3.spi.domain.generator.binding.BindingMatchResult;
import org.fabric3.spi.domain.generator.binding.BindingSelectionException;

public class NoSCABindingProviderException
extends BindingSelectionException {
    private static final long serialVersionUID = -7797860974206005955L;
    private transient List<BindingMatchResult> results;

    public NoSCABindingProviderException(String message, List<BindingMatchResult> results) {
        super(message);
        this.results = results;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        if (!this.results.isEmpty()) {
            builder.append("\nThe SCA binding selectors reported the following:\n");
            for (BindingMatchResult result : this.results) {
                builder.append(result.getType()).append("\n");
                for (String reason : result.getReasons()) {
                    builder.append("  ").append(reason).append("\n");
                }
            }
        }
        return builder.toString();
    }
}

