/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain.generator.binding;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.Source;
import org.fabric3.spi.domain.generator.binding.BindingProvider;
import org.fabric3.spi.domain.generator.binding.BindingSelectionStrategy;
import org.oasisopen.sca.annotation.Property;

public class ConfigurableBindingSelectionStrategy
implements BindingSelectionStrategy {
    private Map<QName, Integer> bindingOrder;
    private BindingProviderComparator comparator = new BindingProviderComparator();

    @Property(required=false)
    @Source(value="$systemConfig//f3:bindings/f3:binding.sca/f3:provider.order")
    public void setScaBindingOrder(List<QName> order) {
        this.bindingOrder = new HashMap<QName, Integer>(order.size());
        for (int i = 0; i < order.size(); ++i) {
            QName name = order.get(i);
            this.bindingOrder.put(name, i);
        }
    }

    public void order(List<BindingProvider> providers) {
        if (this.bindingOrder == null || providers.isEmpty()) {
            return;
        }
        Collections.sort(providers, this.comparator);
    }

    private class BindingProviderComparator
    implements Comparator<BindingProvider> {
        private BindingProviderComparator() {
        }

        @Override
        public int compare(BindingProvider one, BindingProvider two) {
            Integer posTwo;
            Integer posOne = (Integer)ConfigurableBindingSelectionStrategy.this.bindingOrder.get(one.getType());
            if (posOne == null) {
                posOne = -1;
            }
            if ((posTwo = (Integer)ConfigurableBindingSelectionStrategy.this.bindingOrder.get(two.getType())) == null) {
                posTwo = -1;
            }
            return posOne - posTwo;
        }
    }
}

