/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.net.URI;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Autowire;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.CompositeImplementation;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.fabric.domain.LCMMonitor;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class LogicalComponentManagerImpl
implements LogicalComponentManager {
    private URI domainUri;
    private String autowireValue;
    private Autowire autowire = Autowire.OFF;
    private LogicalCompositeComponent domain;
    private LCMMonitor monitor;

    public LogicalComponentManagerImpl() {
        this.domainUri = Names.RUNTIME_URI;
        this.autowire = Autowire.ON;
        this.initializeDomainComposite();
    }

    @Constructor
    public LogicalComponentManagerImpl(@Reference HostInfo info) {
        this.domainUri = info.getDomain();
        this.initializeDomainComposite();
    }

    @Property(required=false)
    @Source(value="$systemConfig/f3:domain/@autowire")
    public void setAutowire(String value) {
        this.autowireValue = value;
    }

    @Monitor
    public void setMonitor(LCMMonitor monitor) {
        this.monitor = monitor;
    }

    @Init
    public void init() {
        Autowire autowire;
        if (this.autowireValue == null) {
            return;
        }
        if ("ON".equalsIgnoreCase(this.autowireValue.trim())) {
            autowire = Autowire.ON;
        } else if ("OFF".equalsIgnoreCase(this.autowireValue.trim())) {
            autowire = Autowire.OFF;
        } else {
            this.monitor.invalidAutowireValue(this.autowireValue);
            autowire = Autowire.OFF;
        }
        this.autowire = autowire;
        if (this.domain != null) {
            this.domain.setAutowire(autowire);
        }
    }

    public LogicalComponent<?> getComponent(URI uri) {
        String defragmentedUri = UriHelper.getDefragmentedNameAsString((URI)uri);
        String domainString = this.domain.getUri().toString();
        String[] hierarchy = defragmentedUri.substring(domainString.length() + 1).split("/");
        String currentUri = domainString;
        LogicalCompositeComponent currentComponent = this.domain;
        for (String name : hierarchy) {
            currentUri = currentUri + "/" + name;
            if (currentComponent instanceof LogicalCompositeComponent) {
                LogicalCompositeComponent composite = currentComponent;
                currentComponent = composite.getComponent(URI.create(currentUri));
            }
            if (currentComponent != null) continue;
            return null;
        }
        return currentComponent;
    }

    public LogicalCompositeComponent getRootComponent() {
        return this.domain;
    }

    public void replaceRootComponent(LogicalCompositeComponent component) {
        this.domain = component;
    }

    private void initializeDomainComposite() {
        Composite type = new Composite(null);
        CompositeImplementation impl = new CompositeImplementation();
        impl.setComponentType((ComponentType)type);
        ComponentDefinition definition = new ComponentDefinition(this.domainUri.toString());
        definition.setImplementation((Implementation)impl);
        definition.setContributionUri(Names.BOOT_CONTRIBUTION);
        type.setAutowire(this.autowire);
        this.domain = new LogicalCompositeComponent(this.domainUri, definition, null);
        this.domain.setState(LogicalState.PROVISIONED);
        this.domain.setAutowire(this.autowire);
    }
}

