/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.util.List;
import java.util.ListIterator;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.command.ExecutorNotFoundException;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.container.command.CompensatableCommand;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.DeployerMonitor;
import org.fabric3.spi.domain.DeploymentPackage;
import org.fabric3.spi.domain.generator.DeploymentUnit;
import org.oasisopen.sca.annotation.Reference;

public class LocalDeployer
implements Deployer {
    private CommandExecutorRegistry executorRegistry;
    private ScopeRegistry scopeRegistry;
    private DeployerMonitor monitor;

    public LocalDeployer(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Monitor DeployerMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.scopeRegistry = scopeRegistry;
        this.monitor = monitor;
    }

    public void deploy(DeploymentPackage deploymentPackage) throws DeploymentException {
        DeploymentUnit unit = deploymentPackage.getCurrentDeployment().getDeploymentUnit();
        List provisionCommands = unit.getProvisionCommands();
        this.execute(provisionCommands);
        List commands = unit.getCommands();
        this.execute(commands);
        try {
            if (this.scopeRegistry != null) {
                this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
            }
        }
        catch (InstanceLifecycleException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void execute(List<CompensatableCommand> commands) throws DeploymentException {
        int marker = 0;
        for (Command command : commands) {
            try {
                this.executorRegistry.execute(command);
                ++marker;
            }
            catch (ContainerException e) {
                this.rollback(commands, marker);
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    private void rollback(List<CompensatableCommand> commands, int marker) {
        try {
            this.monitor.rollback("local");
            ListIterator<CompensatableCommand> iter = commands.listIterator(marker);
            while (iter.hasPrevious()) {
                CompensatableCommand command = iter.previous();
                CompensatableCommand compensating = command.getCompensatingCommand();
                this.executorRegistry.execute((Command)compensating);
            }
            if (this.scopeRegistry != null) {
                this.scopeRegistry.getScopeContainer(Scope.COMPOSITE).reinject();
            }
        }
        catch (ExecutorNotFoundException ex) {
            this.monitor.rollbackAborted();
        }
        catch (ContainerException ex) {
            this.monitor.rollbackError("local", (Throwable)ex);
        }
    }
}

