/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.domain;

import java.util.List;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.fabric.domain.AbstractDomain;
import org.fabric3.fabric.domain.ContributionHelper;
import org.fabric3.fabric.domain.collector.Collector;
import org.fabric3.fabric.domain.instantiator.LogicalModelInstantiator;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.domain.DeployListener;
import org.fabric3.spi.domain.Deployer;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.domain.allocator.Allocator;
import org.fabric3.spi.domain.generator.Generator;
import org.fabric3.spi.domain.generator.binding.BindingSelectionException;
import org.fabric3.spi.domain.generator.binding.BindingSelector;
import org.fabric3.spi.domain.generator.policy.PolicyAttacher;
import org.fabric3.spi.domain.generator.policy.PolicyRegistry;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class DistributedDomain
extends AbstractDomain
implements Domain {
    private boolean transactional;
    private BindingSelector bindingSelector;

    public DistributedDomain(@Reference(name="store") MetaDataStore metaDataStore, @Reference(name="logicalComponentManager") LogicalComponentManager logicalComponentManager, @Reference Generator generator, @Reference LogicalModelInstantiator logicalModelInstantiator, @Reference PolicyAttacher policyAttacher, @Reference BindingSelector bindingSelector, @Reference Deployer deployer, @Reference Collector collector, @Reference ContributionHelper contributionHelper, @Reference HostInfo info) {
        super(metaDataStore, logicalComponentManager, generator, logicalModelInstantiator, policyAttacher, deployer, collector, contributionHelper, info);
        this.generateFullDeployment = RuntimeMode.CONTROLLER == info.getRuntimeMode();
        this.bindingSelector = bindingSelector;
    }

    @Reference(required=false)
    public void setAllocator(Allocator allocator) {
        this.allocator = allocator;
    }

    @Reference
    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    @Reference(required=false)
    public void setListeners(List<DeployListener> listeners) {
        this.listeners = listeners;
    }

    @Reference(required=false)
    public void setPolicyRegistry(PolicyRegistry policyRegistry) {
        this.policyRegistry = policyRegistry;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:deployment/@transactional")
    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    @Override
    protected boolean isLocal() {
        return this.info.supportsClassLoaderIsolation() && RuntimeMode.CONTROLLER != this.info.getRuntimeMode();
    }

    @Override
    protected boolean isTransactional() {
        if (this.info.getRuntimeMode() == RuntimeMode.CONTROLLER) {
            return true;
        }
        if (this.info.getRuntimeMode() == RuntimeMode.VM) {
            return this.transactional;
        }
        return false;
    }

    @Override
    protected void selectBinding(LogicalCompositeComponent domain) throws DeploymentException {
        try {
            this.bindingSelector.selectBindings(domain);
        }
        catch (BindingSelectionException e) {
            throw new DeploymentException((Throwable)e);
        }
    }
}

