/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.wire;

import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;

public class InvocationChainImpl
implements InvocationChain {
    protected PhysicalOperationDefinition physicalOperation;
    protected Interceptor interceptorChainHead;
    protected Interceptor interceptorChainTail;

    public InvocationChainImpl(PhysicalOperationDefinition operation) {
        this.physicalOperation = operation;
    }

    public PhysicalOperationDefinition getPhysicalOperation() {
        return this.physicalOperation;
    }

    public void addInterceptor(Interceptor interceptor) {
        if (this.interceptorChainHead == null) {
            this.interceptorChainHead = interceptor;
        } else {
            this.interceptorChainTail.setNext(interceptor);
        }
        this.interceptorChainTail = interceptor;
    }

    public void addInterceptor(int index, Interceptor interceptor) {
        Interceptor next;
        int i = 0;
        Interceptor prev = null;
        for (next = this.interceptorChainHead; next != null && i < index; next = next.getNext(), ++i) {
            prev = next;
        }
        if (i == index) {
            if (prev != null) {
                prev.setNext(interceptor);
            } else {
                this.interceptorChainHead = interceptor;
            }
            interceptor.setNext(next);
            if (next == null) {
                this.interceptorChainTail = interceptor;
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public Interceptor getHeadInterceptor() {
        return this.interceptorChainHead;
    }

    public Interceptor getTailInterceptor() {
        return this.interceptorChainTail;
    }
}

