/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.interceptor;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.interceptor.TransformerInterceptor;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InterceptorCreationException;
import org.fabric3.spi.container.wire.NoInterceptorException;
import org.fabric3.spi.container.wire.TransformerInterceptorFactory;
import org.fabric3.spi.model.physical.ParameterTypeHelper;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class TransformerInterceptorFactoryImpl
implements TransformerInterceptorFactory {
    private TransformerRegistry registry;

    public TransformerInterceptorFactoryImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    public Interceptor createInterceptor(PhysicalOperationDefinition definition, List<DataType> sources, List<DataType> targets, ClassLoader targetLoader, ClassLoader sourceLoader) throws InterceptorCreationException {
        List<Class<?>> targetTypes = this.loadTargetInputTypes(definition, targetLoader);
        List<Class<?>> sourceTypes = this.loadSourceInputTypes(definition, targetLoader);
        try {
            Transformer inTransformer = null;
            DataType selectedSource = null;
            DataType selectedTarget = null;
            for (DataType source : sources) {
                for (DataType target : targets) {
                    inTransformer = this.registry.getTransformer(source, target, sourceTypes, targetTypes);
                    if (inTransformer == null) continue;
                    selectedSource = source;
                    selectedTarget = target;
                    break;
                }
                if (selectedSource == null) continue;
                break;
            }
            if (inTransformer == null) {
                throw new NoInterceptorException("No transformer found for operation: " + definition.getName());
            }
            List<Class<?>> sourceOutTypes = this.loadSourceOutputTypes(definition, targetLoader);
            List<Class<?>> targetOutTypes = this.loadTargetOutputTypes(definition, targetLoader);
            Transformer outTransformer = this.registry.getTransformer(selectedTarget, selectedSource, targetOutTypes, sourceOutTypes);
            if (outTransformer == null) {
                throw new NoInterceptorException("No transformer from type " + selectedTarget + " to type " + selectedSource);
            }
            return new TransformerInterceptor((Transformer<Object, Object>)inTransformer, (Transformer<Object, Object>)outTransformer, targetLoader, sourceLoader);
        }
        catch (TransformationException e) {
            throw new InterceptorCreationException((Throwable)e);
        }
    }

    private List<Class<?>> loadSourceInputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws InterceptorCreationException {
        try {
            return ParameterTypeHelper.loadSourceInParameterTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorCreationException((Throwable)e);
        }
    }

    private List<Class<?>> loadTargetInputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws InterceptorCreationException {
        try {
            return ParameterTypeHelper.loadTargetInParameterTypes((PhysicalOperationDefinition)definition, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorCreationException((Throwable)e);
        }
    }

    private List<Class<?>> loadSourceOutputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws InterceptorCreationException {
        ArrayList types = new ArrayList();
        try {
            Class outParam = ParameterTypeHelper.loadSourceOutputType((PhysicalOperationDefinition)definition, (ClassLoader)loader);
            types.add(outParam);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorCreationException((Throwable)e);
        }
        return types;
    }

    private List<Class<?>> loadTargetOutputTypes(PhysicalOperationDefinition definition, ClassLoader loader) throws InterceptorCreationException {
        ArrayList types = new ArrayList();
        try {
            Class outParam = ParameterTypeHelper.loadTargetOutputType((PhysicalOperationDefinition)definition, (ClassLoader)loader);
            types.add(outParam);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorCreationException((Throwable)e);
        }
        return types;
    }
}

