/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.handler;

import java.util.List;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.fabric.container.handler.NoTransformerException;
import org.fabric3.fabric.container.handler.TransformerHandler;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.HandlerCreationException;
import org.fabric3.spi.container.channel.TransformerHandlerFactory;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class TransformerHandlerFactoryImpl
implements TransformerHandlerFactory {
    private TransformerRegistry registry;

    public TransformerHandlerFactoryImpl(@Reference TransformerRegistry registry) {
        this.registry = registry;
    }

    public EventStreamHandler createHandler(DataType source, DataType target, List<Class<?>> eventTypes, ClassLoader loader) throws HandlerCreationException {
        try {
            Transformer transformer = this.registry.getTransformer(source, target, eventTypes, eventTypes);
            if (transformer == null) {
                throw new NoTransformerException("No transformer found for event types: " + source + "," + target);
            }
            return new TransformerHandler((Transformer<Object, Object>)transformer, loader);
        }
        catch (TransformationException e) {
            throw new HandlerCreationException((Throwable)e);
        }
    }
}

