/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.net.URI;
import java.util.ArrayList;
import org.fabric3.api.host.contribution.ContributionNotFoundException;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.RemoveException;
import org.fabric3.api.host.contribution.UninstallException;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.fabric.container.command.UnProvisionExtensionsCommand;
import org.fabric3.fabric.container.executor.ProvisionedExtensionTracker;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.executor.ExecutionException;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.ResolutionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class UnProvisionExtensionsCommandExecutor
implements CommandExecutor<UnProvisionExtensionsCommand> {
    private Domain domain;
    private CommandExecutorRegistry commandExecutorRegistry;
    private ContributionService contributionService;
    private ContributionResolver resolver;
    private ProvisionedExtensionTracker tracker;

    public UnProvisionExtensionsCommandExecutor(@Reference(name="domain") Domain domain, @Reference CommandExecutorRegistry commandExecutorRegistry, @Reference ContributionService contributionService, @Reference ContributionResolver resolver, @Reference ProvisionedExtensionTracker tracker) {
        this.commandExecutorRegistry = commandExecutorRegistry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.resolver = resolver;
        this.tracker = tracker;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(UnProvisionExtensionsCommand.class, (CommandExecutor)this);
    }

    public synchronized void execute(UnProvisionExtensionsCommand command) throws ContainerException {
        ArrayList<URI> uninstall = new ArrayList<URI>();
        for (URI uri : command.getExtensionUris()) {
            int count = this.tracker.decrement(uri);
            if (count != 0) continue;
            try {
                this.domain.undeploy(uri, false);
                uninstall.add(uri);
                this.resolver.release(uri);
            }
            catch (DeploymentException | ResolutionException e) {
                throw new ExecutionException(e);
            }
        }
        try {
            this.contributionService.uninstall(uninstall);
            this.contributionService.remove(uninstall);
        }
        catch (ContributionNotFoundException | RemoveException | UninstallException e) {
            throw new ExecutionException(e);
        }
    }
}

