/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.command.StopContextCommand;
import org.fabric3.fabric.container.executor.ContextMonitor;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class StopContextCommandExecutor
implements CommandExecutor<StopContextCommand> {
    private CommandExecutorRegistry executorRegistry;
    private ChannelManager channelManager;
    private ScopeContainer compositeScopeContainer;
    private ScopeContainer domainScopeContainer;
    private ContextMonitor monitor;

    public StopContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Reference ChannelManager channelManager, @Monitor ContextMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.channelManager = channelManager;
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.executorRegistry.register(StopContextCommand.class, (CommandExecutor)this);
    }

    public void execute(StopContextCommand command) throws ContainerException {
        QName deployable = command.getDeployable();
        WorkContextCache.getAndResetThreadWorkContext();
        this.compositeScopeContainer.stopContext(deployable);
        if (this.domainScopeContainer != null) {
            this.domainScopeContainer.stopContext(deployable);
        }
        this.channelManager.stopContext(deployable);
        if (this.monitor != null && command.isLog()) {
            this.monitor.undeployed(deployable);
        }
    }
}

