/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.command.StartContextCommand;
import org.fabric3.fabric.container.executor.ContextMonitor;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class StartContextCommandExecutor
implements CommandExecutor<StartContextCommand> {
    private ScopeContainer compositeScopeContainer;
    private ScopeContainer domainScopeContainer;
    private CommandExecutorRegistry commandExecutorRegistry;
    private ChannelManager channelManager;
    private ContextMonitor monitor;

    @Constructor
    public StartContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Reference ChannelManager channelManager, @Monitor ContextMonitor monitor) {
        this.commandExecutorRegistry = executorRegistry;
        this.channelManager = channelManager;
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
        this.monitor = monitor;
    }

    public StartContextCommandExecutor(ScopeRegistry scopeRegistry, @Monitor ContextMonitor monitor) {
        this(null, scopeRegistry, null, monitor);
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(StartContextCommand.class, (CommandExecutor)this);
    }

    public void execute(StartContextCommand command) throws ContainerException {
        QName deployable = command.getDeployable();
        WorkContextCache.getAndResetThreadWorkContext();
        if (this.channelManager != null) {
            this.channelManager.startContext(deployable);
        }
        this.compositeScopeContainer.startContext(deployable);
        if (this.domainScopeContainer != null) {
            this.domainScopeContainer.startContext(deployable);
        }
        if (command.isLog()) {
            this.monitor.deployed(deployable);
        }
    }
}

