/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.fabric3.api.host.contribution.ContributionException;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.FileContributionSource;
import org.fabric3.api.host.domain.DeploymentException;
import org.fabric3.api.host.domain.Domain;
import org.fabric3.fabric.container.command.ProvisionExtensionsCommand;
import org.fabric3.fabric.container.executor.ProvisionedExtensionTracker;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.executor.ExecutionException;
import org.fabric3.spi.contribution.ContributionResolver;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ProvisionExtensionsCommandExecutor
implements CommandExecutor<ProvisionExtensionsCommand> {
    private CommandExecutorRegistry commandExecutorRegistry;
    private ContributionService contributionService;
    private Domain domain;
    private ContributionResolver resolver;
    private ProvisionedExtensionTracker tracker;

    public ProvisionExtensionsCommandExecutor(@Reference(name="domain") Domain domain, @Reference CommandExecutorRegistry commandExecutorRegistry, @Reference ContributionService contributionService, @Reference ContributionResolver resolver, @Reference ProvisionedExtensionTracker tracker) {
        this.commandExecutorRegistry = commandExecutorRegistry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.resolver = resolver;
        this.tracker = tracker;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(ProvisionExtensionsCommand.class, (CommandExecutor)this);
    }

    public void execute(ProvisionExtensionsCommand command) throws ContainerException {
        try {
            ArrayList<URI> stored = new ArrayList<URI>();
            for (URI uri : command.getExtensionUris()) {
                if (this.contributionService.exists(uri)) continue;
                URL url = this.resolver.resolve(uri);
                FileContributionSource source = new FileContributionSource(uri, url, 0L, true);
                this.contributionService.store((ContributionSource)source);
                stored.add(uri);
                this.tracker.increment(uri);
            }
            if (stored.isEmpty()) {
                return;
            }
            this.contributionService.install(stored);
            this.domain.include(stored);
        }
        catch (ContributionException | DeploymentException e) {
            throw new ExecutionException(e);
        }
    }
}

