/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.net.URI;
import org.fabric3.fabric.container.command.AttachWireCommand;
import org.fabric3.fabric.container.command.ConnectionCommand;
import org.fabric3.fabric.container.command.DetachWireCommand;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.executor.ExecutionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConnectionCommandExecutor
implements CommandExecutor<ConnectionCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;

    public ConnectionCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(ConnectionCommand.class, (CommandExecutor)this);
    }

    public void execute(ConnectionCommand command) throws ContainerException {
        URI uri = command.getComponentUri();
        Component component = this.componentManager.getComponent(uri);
        if (component == null) {
            throw new ExecutionException("Component not found: " + uri);
        }
        component.startUpdate();
        for (DetachWireCommand detachWireCommand : command.getDetachCommands()) {
            this.commandExecutorRegistry.execute((Command)detachWireCommand);
        }
        for (AttachWireCommand attachWireCommand : command.getAttachCommands()) {
            this.commandExecutorRegistry.execute((Command)attachWireCommand);
        }
        component.endUpdate();
    }
}

