/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.fabric.container.command.ExecutorNotFoundException;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.command.Command;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class CommandExecutorRegistryImpl
implements CommandExecutorRegistry {
    private Map<Class<? extends Command>, CommandExecutor<?>> executors = new HashMap();

    public <T extends Command> void register(Class<T> type, CommandExecutor<T> executor) {
        this.executors.put(type, executor);
    }

    public <T extends Command> void execute(T command) throws ContainerException {
        Class<?> clazz = command.getClass();
        CommandExecutor<?> executor = this.executors.get(clazz);
        if (executor == null) {
            throw new ExecutorNotFoundException("No registered executor for command: " + clazz.getName());
        }
        executor.execute(command);
    }
}

