/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.util.Map;
import org.fabric3.fabric.container.command.BuildResourcesCommand;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.resource.ResourceBuilder;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.container.executor.ExecutionException;
import org.fabric3.spi.model.physical.PhysicalResourceDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class BuildResourcesCommandExecutor
implements CommandExecutor<BuildResourcesCommand> {
    private CommandExecutorRegistry executorRegistry;
    private Map<Class<?>, ResourceBuilder> builders;

    public BuildResourcesCommandExecutor(@Reference CommandExecutorRegistry registry) {
        this.executorRegistry = registry;
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ResourceBuilder> builders) {
        this.builders = builders;
    }

    @Init
    public void init() {
        this.executorRegistry.register(BuildResourcesCommand.class, (CommandExecutor)this);
    }

    public void execute(BuildResourcesCommand command) throws ContainerException {
        for (PhysicalResourceDefinition definition : command.getDefinitions()) {
            this.build(definition);
        }
    }

    private void build(PhysicalResourceDefinition definition) throws ContainerException {
        ResourceBuilder builder = this.builders.get(definition.getClass());
        if (builder == null) {
            throw new ExecutionException("Builder not found for " + definition.getClass().getName());
        }
        builder.build(definition);
    }
}

