/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.executor;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.container.builder.BuilderNotFoundException;
import org.fabric3.fabric.container.command.BuildComponentCommand;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.ComponentBuilder;
import org.fabric3.spi.container.builder.component.ComponentBuilderListener;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.executor.CommandExecutor;
import org.fabric3.spi.container.executor.CommandExecutorRegistry;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class BuildComponentCommandExecutor
implements CommandExecutor<BuildComponentCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;
    private Map<Class<?>, ComponentBuilder> builders;
    private List<ComponentBuilderListener> listeners = Collections.emptyList();

    @Constructor
    public BuildComponentCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    public BuildComponentCommandExecutor(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(BuildComponentCommand.class, (CommandExecutor)this);
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ComponentBuilder> builders) {
        this.builders = builders;
    }

    @Reference(required=false)
    public void setListeners(List<ComponentBuilderListener> listeners) {
        this.listeners = listeners;
    }

    public void execute(BuildComponentCommand command) throws ContainerException {
        PhysicalComponentDefinition definition = command.getDefinition();
        Component component = this.build(definition);
        URI classLoaderId = definition.getClassLoaderId();
        component.setClassLoaderId(classLoaderId);
        this.componentManager.register(component);
        for (ComponentBuilderListener listener : this.listeners) {
            listener.onBuild(component, definition);
        }
    }

    private Component build(PhysicalComponentDefinition definition) throws ContainerException {
        ComponentBuilder builder = this.builders.get(definition.getClass());
        if (builder == null) {
            throw new BuilderNotFoundException("Builder not found for " + definition.getClass().getName());
        }
        return builder.build(definition);
    }
}

