/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component.scope;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.component.scope.AbstractScopeContainer;
import org.fabric3.fabric.container.component.scope.ScopeContainerMonitor;
import org.fabric3.spi.container.component.GroupInitializationException;
import org.fabric3.spi.container.component.InstanceDestructionException;
import org.fabric3.spi.container.component.InstanceInitException;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Service;

@EagerInit
@Service(value={ScopeContainer.class})
public class StatelessScopeContainer
extends AbstractScopeContainer {
    public StatelessScopeContainer(@Monitor ScopeContainerMonitor monitor) {
        super(Scope.STATELESS, monitor);
    }

    @Override
    @Init
    public void start() {
        super.start();
    }

    @Override
    @Destroy
    public void stop() {
        super.stop();
    }

    public Object getInstance(ScopedComponent component) throws InstanceLifecycleException {
        try {
            Object instance = component.createInstance();
            component.startInstance(instance);
            return instance;
        }
        catch (ObjectCreationException e) {
            throw new InstanceInitException("Error creating instance for: " + component.getUri(), (Throwable)e);
        }
    }

    public void releaseInstance(ScopedComponent component, Object instance) throws InstanceDestructionException {
        component.stopInstance(instance);
    }

    public List<Object> getActiveInstances(ScopedComponent component) {
        return Collections.emptyList();
    }

    public void startContext(QName deployable) throws GroupInitializationException {
    }

    public void stopContext(QName deployable) {
    }

    public void reinject() {
    }
}

