/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component.scope;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.fabric.container.component.scope.ScopeContainerMonitor;
import org.fabric3.fabric.container.component.scope.SingletonScopeContainer;
import org.fabric3.spi.container.component.GroupInitializationException;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.federation.topology.ParticipantTopologyService;
import org.fabric3.spi.federation.topology.TopologyListener;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@EagerInit
@Service(value={ScopeContainer.class, TopologyListener.class})
public class DomainScopeContainer
extends SingletonScopeContainer
implements TopologyListener {
    private HostInfo info;
    private ParticipantTopologyService topologyService;
    private final List<QName> deferredContexts = new ArrayList<QName>();
    boolean activated;

    public DomainScopeContainer(@Reference HostInfo info, @Monitor ScopeContainerMonitor monitor) {
        super(Scope.DOMAIN, monitor);
        this.info = info;
    }

    @Reference(required=false)
    public void setTopologyService(List<ParticipantTopologyService> topologyServices) {
        if (topologyServices.size() > 0) {
            this.topologyService = topologyServices.get(0);
        }
    }

    @Override
    @Init
    public void start() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Destroy
    public synchronized void stop() {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContext(QName deployable) throws GroupInitializationException {
        if ((RuntimeMode.PARTICIPANT == this.info.getRuntimeMode() || RuntimeMode.NODE == this.info.getRuntimeMode()) && this.topologyService == null) {
            return;
        }
        if (!(RuntimeMode.PARTICIPANT != this.info.getRuntimeMode() && RuntimeMode.NODE != this.info.getRuntimeMode() || this.topologyService.isZoneLeader())) {
            List<QName> list = this.deferredContexts;
            synchronized (list) {
                this.deferredContexts.add(deployable);
            }
            return;
        }
        this.activated = true;
        super.startContext(deployable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContext(QName deployable) {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.remove(deployable);
        }
        super.stopContext(deployable);
    }

    @Override
    public Object getInstance(ScopedComponent component) throws InstanceLifecycleException {
        if (this.topologyService != null && !this.activated) {
            throw new InstanceLifecycleException("Component instance not active: " + component.getUri());
        }
        return super.getInstance(component);
    }

    public void onJoin(String name) {
    }

    public void onLeave(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaderElected(String name) {
        if (this.topologyService != null && !this.topologyService.isZoneLeader()) {
            return;
        }
        this.activated = true;
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            WorkContextCache.getAndResetThreadWorkContext();
            for (QName deployable : this.deferredContexts) {
                try {
                    super.startContext(deployable);
                }
                catch (GroupInitializationException e) {
                    this.monitor.leaderElectionError((Exception)((Object)e));
                }
            }
            this.deferredContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllContexts() {
        List<QName> list = this.deferredContexts;
        synchronized (list) {
            this.deferredContexts.clear();
        }
        super.stopAllContexts();
    }
}

