/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.container.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.fabric3.fabric.container.component.DuplicateComponentException;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.RegistrationException;

public class ComponentManagerImpl
implements ComponentManager {
    private Map<URI, Component> components = new ConcurrentHashMap<URI, Component>();

    public synchronized void register(Component component) throws RegistrationException {
        URI uri = component.getUri();
        if (this.components.containsKey(uri)) {
            throw new DuplicateComponentException("A component is already registered for: " + uri.toString());
        }
        this.components.put(uri, component);
    }

    public synchronized Component unregister(URI uri) throws RegistrationException {
        return this.components.remove(uri);
    }

    public Component getComponent(URI name) {
        return this.components.get(name);
    }

    public List<Component> getComponents() {
        return new ArrayList<Component>(this.components.values());
    }

    public List<Component> getComponentsInHierarchy(URI uri) {
        String stringified = uri.toString();
        ArrayList<Component> hierarchy = new ArrayList<Component>();
        for (Component component : this.components.values()) {
            URI componentUri = component.getUri();
            if (!componentUri.toString().startsWith(stringified)) continue;
            hierarchy.add(component);
        }
        return hierarchy;
    }

    public List<Component> getDeployedComponents(QName deployable) {
        ArrayList<Component> deployed = new ArrayList<Component>();
        for (Component component : this.components.values()) {
            if (!deployable.equals(component.getDeployable())) continue;
            deployed.add(component);
        }
        return deployed;
    }
}

